package com.liquidnet.service.executor.main.handler;

import com.liquidnet.service.feign.platform.task.FeignPlatformSmileTaskClient;
import com.liquidnet.service.feign.sweet.task.FeignSweetTaskClient;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * XxlJob开发示例（Bean模式）
 * <p>
 * 开发步骤：
 * 1、在Spring Bean实例中，开发Job方法，方式格式要求为 "public void execute(String param)"
 * 2、为Job方法添加注解 "@XxlJob(value="自定义jobhandler名称", init = "JobHandler初始化方法", destroy = "JobHandler销毁方法")"，注解value值对应的是调度中心新建任务的JobHandler属性的值。
 * 3、执行日志：需要通过 "XxlJobLogger.log" 打印执行日志；
 */
@Component
public class SweetTaskHandler {
    @Autowired
    private FeignSweetTaskClient feignSweetTaskClient;

    private FeignPlatformSmileTaskClient feignPlatformSmileTaskClient;

    @XxlJob(value = "sev-sweet:drawLuckAdd")
    public void drawLuckAdd() {
        try {
            XxlJobHelper.handleSuccess("结果：" + feignSweetTaskClient.drawLuckAdd().getData());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-sweet:setDrawAllList")
    public void setDrawAllListHandler() {
        try {
            String jobParam = XxlJobHelper.getJobParam();
            String[] paramArray = jobParam.split(",");

            for (String id : paramArray) {
                Boolean data = feignSweetTaskClient.setDrawAllList(id).getData();
                XxlJobHelper.log("id:{},结果:{}", data);
            }
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-smile:sellData")
    public void sellDataHandler() {
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformSmileTaskClient.sellData().toJson());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }
    @XxlJob(value = "sev-smile:commissionData")
    public void sellcommissionDataHandler() {
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformSmileTaskClient.commissionData().toJson());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }
}
