drop schema if exists liquidnet_wac;
create database liquidnet_wac character set utf8mb4 collate utf8mb4_unicode_ci;
-- >>------------------------------------------------------------------------------------1
drop table if exists liquidnet_wac.FIN_N02, liquidnet_wac.FIN_N01;
create table liquidnet_wac.FIN_N01
(
    FD0 varchar(32) not null,
    FD1 varchar(32),
    FD2 varchar(50),
    FD3 int(5),
    FD4 varchar(100)
) engine = innodb;

alter table liquidnet_wac.FIN_N01
    add constraint PK_FIN_AC_N01 primary key (FD0);
create index IDX_FIN_AC_N01_1 on liquidnet_wac.FIN_N01 (FD1);
-- >>------------------------------------------------------------------------------------2
create table liquidnet_wac.FIN_N02
(
    FDV0 varchar(32) not null,
    FDV1 varchar(32),
    FDV2 varchar(50),
    FDV3 varchar(100),
    FDV4 int(5),
    FDV5 varchar(255)
) engine = innodb;

alter table liquidnet_wac.FIN_N02
    add constraint PK_FIN_AC_N02 primary key (FDV0);
alter table liquidnet_wac.FIN_N02
    add constraint FK_FIN_AC_N02_1
        foreign key (FDV1) references liquidnet_wac.FIN_N01 (FD0);
-- >>------------------------------------------------------------------------------------3
# drop table if exists liquidnet_wac.FIN_CONFIG;
# create table liquidnet_wac.FIN_CONFIG
# (
#     id          varchar(32) not null,
#     `key`       varchar(50) not null,
#     value       varchar(4000),
#     update_time timestamp,
#     remark      varchar(100)
# ) engine = innodb;
#
# alter table liquidnet_wac.FIN_CONFIG
#     add constraint PK_FIN_CONFIG primary key (id);
# create index IDX_FIN_CONFIG_1 on liquidnet_wac.FIN_CONFIG (`key`);
-- >>------------------------------------------------------------------------------------ |WL_N01
drop table if exists liquidnet_wac.FIN_AC_N07, liquidnet_wac.FIN_AC_N06, liquidnet_wac.FIN_WL_N01;
create table liquidnet_wac.FIN_WL_N01
(
    FC0 varchar(32),
    FC1 varchar(12),
    FC2 varchar(50),
    FC3 varchar(8),
    FC4 varchar(128),
    FC5 datetime,
    FC6 datetime,
    FC7 varchar(64)
) engine = innodb;

alter table liquidnet_wac.FIN_WL_N01
    add constraint PK_FIN_WL_N01 primary key (FC0);
-- >>------------------------------------------------------------------------------------ |WL_N02
# create table liquidnet_wac.FIN_WL_N02
# (
#     FCA0 varchar(32) not null,
#     FCA1 varchar(32),
#     FCA2 varchar(16),
#     FCA3 varchar(16),
#     FCA4 varchar(5),
#     FCA5 varchar(2),
#     FCA6 varchar(8),
#     FCA7 varchar(64),
#     FCA8 varchar(100),
#     FCA9 datetime
# ) engine = innodb;
#
# alter table liquidnet_wac.FIN_WL_N02
#     add constraint PK_FIN_WL_N02 primary key (FCA0);
# alter table liquidnet_wac.FIN_WL_N02
#     add constraint FK_FIN_WL_N02_1
#         foreign key (FCA1) references liquidnet_wac.FIN_WL_N01 (FC0);
-- >>------------------------------------------------------------------------------------
-- >>------------------------------------------------------------------------------------
-- >>------------------------------------------------------------------------------------ |WL_N03
drop table if exists liquidnet_wac.FIN_WL_N03;
create table liquidnet_wac.FIN_WL_N03
(
    FU0 varchar(32) not null,
    FU1 varchar(64),
    FU2 varchar(150),
    FU3 varchar(32),
    FU4 varchar(8),
    FU5 varchar(32),
    FU6 varchar(2),
    FU7 datetime,
    FU8 datetime
) engine = innodb;

alter table liquidnet_wac.FIN_WL_N03
    add constraint PK_FIN_WL_N03 primary key (FU0);
create unique index UIDX_FIN_WL_N03_1 on liquidnet_wac.FIN_WL_N03 (FU1, FU3);
-- create index IDX_FIN_WL_N03_1 on liquidnet_wac.FIN_WL_N03 (FU1);
-- alter table liquidnet_wac.FIN_WL_N03 add FU09 varchar(100);
-- >>------------------------------------------------------------------------------------ |WL_N04
# drop table if exists liquidnet_wac.FIN_USER_STATUS_LOG;
# create table liquidnet_wac.FIN_USER_STATUS_LOG
# (
#     log_id       varchar(32) not null,
#     fin_id       varchar(32) not null,
#     status_from  varchar(8),
#     status_to    varchar(8),
#     operate_time datetime,
#     operate_user varchar(64)
# ) engine = innodb;
#
# alter table liquidnet_wac.FIN_USER_STATUS_LOG
#     add constraint PK_FIN_USER_STATUS_LOG primary key (log_id);
-- >>------------------------------------------------------------------------------------ |WL_N05
drop table if exists liquidnet_wac.FIN_WL_N05;
create table liquidnet_wac.FIN_WL_N05
(
    FW0  varchar(32) not null,
    FW1  varchar(5),
    FW2  varchar(100),
    FW3  int(5),
    FW4  int(5),
    FW5  varchar(32),
    FW6  varchar(32),
    FW7  varchar(32),
    FW8  datetime,
    FW9  varchar(64),
    FW10 datetime,
    FW11 varchar(64),
    FW12 datetime,
    FW13 varchar(64)
) engine = innodb;

alter table liquidnet_wac.FIN_WL_N05
    add constraint PK_FIN_WL_N05 PRIMARY KEY (FW0);
-- >>------------------------------------------------------------------------------------ |WL_N06
# drop table if exists liquidnet_wac.FIN_WL_N06;
# create table liquidnet_wac.FIN_WL_N06
# (
#     FWA0 varchar(32) not null,
#     FWA1 varchar(32)
# ) engine = innodb;
#
# alter table liquidnet_wac.FIN_WL_N06
#     add constraint PK_FIN_WL_N06 PRIMARY KEY (FWA0);
-- >>------------------------------------------------------------------------------------ |WL_N07
drop table if exists liquidnet_wac.FIN_WL_N07;
create table liquidnet_wac.FIN_WL_N07
(
    FBT0  varchar(64) not null,
    FBT1  varchar(32),
    FBT2  varchar(32),
    FBT3  decimal(20, 6),
    FBT4  varchar(22),
    FBT5  int(5),
    FBT6  varchar(64),
    FBT7  varchar(64),
    FBT8  varchar(30),
    FBT9  datetime,
    FBT10 varchar(100),
    FBT11 varchar(100),
    FBT12 datetime,
    FBT13 datetime,
    FBT14 datetime,
    FBT15 varchar(255),
    FBT16 varchar(100)
) engine = innodb;

alter table liquidnet_wac.FIN_WL_N07
    add constraint PK_FIN_WL_N07 PRIMARY KEY (FBT0);
-- >>------------------------------------------------------------------------------------ |WL_N08
drop table if exists liquidnet_wac.FIN_WL_N08;
create table liquidnet_wac.FIN_WL_N08
(
    FBTE0 varchar(64) not null,
    FBTE1 varchar(32),
    FBTE2 decimal(20, 6),
    FBTE3 decimal(20, 6),
    FBTE4 decimal(20, 6),
    FBTE5 int(5),
    FBTE6 datetime,
    FBTE7 datetime
) engine = innodb;

alter table liquidnet_wac.FIN_WL_N08
    add constraint PK_FIN_WL_N08 PRIMARY KEY (FBTE0);
-- >>------------------------------------------------------------------------------------ |WL_N09
drop table if exists liquidnet_wac.FIN_WL_N09;
create table liquidnet_wac.FIN_WL_N09
(
    FPNL0 varchar(32) not null,
    FPNL1 varchar(30),
    FPNL2 varchar(64),
    FPNL3 varchar(60),
    FPNL4 datetime,
    FPNL5 varchar(255),
    FPNL6 varchar(4000)
) engine = innodb;

alter table liquidnet_wac.FIN_WL_N09
    add constraint PK_FIN_WL_N09 PRIMARY KEY (FPNL0);
-- >>------------------------------------------------------------------------------------ |WL_N10
drop table if exists liquidnet_wac.FIN_WL_N10;
create table liquidnet_wac.FIN_WL_N10
(
    FBT10 varchar(64) not null,
    FBT11 varchar(32),
    FBT12 varchar(16),
    FBT13 varchar(50),
    FBT14 int(5),
    FBT15 datetime,
    FBT16 datetime,
    FBT17 varchar(2048),
    FBT18 varchar(255)
) engine = innodb;

alter table liquidnet_wac.FIN_WL_N10
    add constraint PK_FIN_WL_N10 PRIMARY KEY (FBT10);
-- >>------------------------------------------------------------------------------------ |AC_N01
drop table if exists liquidnet_wac.FIN_AC_N01;
create table liquidnet_wac.FIN_AC_N01
(
    -- '3-[510]'+'19-[idgen]'
    FA0  varchar(32) not null,
    FA1  varchar(32),
    FA2  varchar(16),
    FA3  varchar(5),
    FA4  int(5),
    FA5  varchar(100),
    FA6  varchar(32),
    FA7  varchar(32),
    FA8  int(5),
    FA9  int(5),
    FA10 datetime,
    FA11 datetime,
    FA12 datetime,
    FA13 datetime,
    FA14 int(5),
    FA15 varchar(32)
) engine = innodb;

alter table liquidnet_wac.FIN_AC_N01
    add constraint PK_FIN_AC_N10 primary key (FA0);
-- >>------------------------------------------------------------------------------------ |AC_N02
# drop table if exists liquidnet_wac.FIN_AC_N02;
# create table liquidnet_wac.FIN_AC_N02
# (
#     FAB0          varchar(32) not null,
#     FAB1           varchar(32),
#     FAB2        varchar(32),
#     FAB3           varchar(32),
#     FAB4         varchar(8),
#     FAB5           decimal(20, 6),
#     FAB6         varchar(32),
#     FAB7       int(5),
#     FAB8      varchar(64),
#     FAB9    datetime,
#     FAB10     datetime,
#     FAB11          varchar(100)
# ) engine = innodb;
#
# alter table liquidnet_wac.FIN_AC_N02
#     add constraint PK_FIN_AC_N02 primary key (FAB0);
# create index IDX_FIN_AC_N02_01 on liquidnet_wac.FIN_AC_N02 (FAB1);

drop procedure if exists liquidnet_wac._init_table;
delimiter ;;
create procedure liquidnet_wac._init_table()
begin
    declare `@i` int(11);
    declare `@tn` varchar(20);
    declare `@dropSql` varchar(2560);
    declare `@createSql` varchar(2560);
    declare `@pkSql` varchar(256);
    declare `@idxSql1` varchar(256);
    declare `@idxSql2` varchar(256);
    declare `@idxSql3` varchar(256);

    set @i = 0;
    while @i < 25 do
            set @tn = concat('liquidnet_wac.FIN_AC_N02_', @i);

            set @dropSql = concat('drop table if exists ', @tn);
            prepare stmt from @dropSql;
            execute stmt;

            set @createSql = concat(
                    'create table ', @tn, '
                        (
                            FAB0          varchar(32) not null,
                            FAB1           varchar(32),
                            FAB2        varchar(32),
                            FAB3           varchar(32),
                            FAB4         varchar(8),
                            FAB5           decimal(20, 6),
                            FAB6         varchar(32),
                            FAB7       int(5),
                            FAB8      varchar(64),
                            FAB9    datetime,
                            FAB10     datetime,
                            FAB11          varchar(100)
                        ) engine = innodb'
                );
            prepare stmt from @createSql;
            execute stmt;

            set @pkSql =
                    concat('alter table ', @tn, ' add constraint PK_FIN_AC_N02_', @i, ' primary key (FAB0)');
            prepare stmt from @pkSql;
            execute stmt;

            set @idxSql1 = concat('create index IDX_PK_FIN_AC_N02_', @i, '_1 on ', @tn, ' (FAB1)');
            prepare stmt from @idxSql1;
            execute stmt;

            set @i = @i + 1;
        end while;
end
;;
delimiter ;
call liquidnet_wac._init_table();
drop procedure if exists liquidnet_wac._init_table;
-- >>------------------------------------------------------------------------------------
-- >>------------------------------------------------------------------------------------
-- select 0 ,count(1) ct  from liquidnet_wac.FIN_AC_N02_0  union all
-- select 1 ,count(1) ct  from liquidnet_wac.FIN_AC_N02_1  union all
-- select 2 ,count(1) ct  from liquidnet_wac.FIN_AC_N02_2  union all
-- select 3 ,count(1) ct  from liquidnet_wac.FIN_AC_N02_3  union all
-- select 4 ,count(1) ct  from liquidnet_wac.FIN_AC_N02_4  union all
-- select 5 ,count(1) ct  from liquidnet_wac.FIN_AC_N02_5  union all
-- select 6 ,count(1) ct  from liquidnet_wac.FIN_AC_N02_6  union all
-- select 7 ,count(1) ct  from liquidnet_wac.FIN_AC_N02_7  union all
-- select 8 ,count(1) ct  from liquidnet_wac.FIN_AC_N02_8  union all
-- select 9 ,count(1) ct  from liquidnet_wac.FIN_AC_N02_9  union all
-- select 10,count(1) ct  from liquidnet_wac.FIN_AC_N02_10 union all
-- select 11,count(1) ct  from liquidnet_wac.FIN_AC_N02_11 union all
-- select 12,count(1) ct  from liquidnet_wac.FIN_AC_N02_12 union all
-- select 13,count(1) ct  from liquidnet_wac.FIN_AC_N02_13 union all
-- select 14,count(1) ct  from liquidnet_wac.FIN_AC_N02_14 union all
-- select 15,count(1) ct  from liquidnet_wac.FIN_AC_N02_15 union all
-- select 16,count(1) ct  from liquidnet_wac.FIN_AC_N02_16 union all
-- select 17,count(1) ct  from liquidnet_wac.FIN_AC_N02_17 union all
-- select 18,count(1) ct  from liquidnet_wac.FIN_AC_N02_18 union all
-- select 19,count(1) ct  from liquidnet_wac.FIN_AC_N02_19 union all
-- select 19,count(1) ct  from liquidnet_wac.FIN_AC_N02_20 union all
-- select 19,count(1) ct  from liquidnet_wac.FIN_AC_N02_21 union all
-- select 19,count(1) ct  from liquidnet_wac.FIN_AC_N02_22 union all
-- select 19,count(1) ct  from liquidnet_wac.FIN_AC_N02_23 union all
-- select 19,count(1) ct  from liquidnet_wac.FIN_AC_N02_24
-- ;
-- >>------------------------------------------------------------------------------------
# USE information_schema;
# SELECT T.TABLE_SCHEMA,
#        C.CHARACTER_SET_NAME,
#        T.TABLE_TYPE,
#        T.ENGINE,
#        T.TABLE_NAME,
#        C.ORDINAL_POSITION,
#        C.COLUMN_NAME,
#        C.COLUMN_TYPE,
#        C.IS_NULLABLE,
#        C.COLUMN_KEY,
#        C.EXTRA,
#        C.COLUMN_COMMENT
# FROM COLUMNS C
#          INNER JOIN TABLES T ON C.TABLE_SCHEMA = T.TABLE_SCHEMA
#     AND C.TABLE_NAME = T.TABLE_NAME
# WHERE T.TABLE_SCHEMA = 'liquidnet_wac';
-- >>------------------------------------------------------------------------------------
-- >>------------------------------------------------------------------------------------
