package com.liquidnet.service.feign.platform.task;

import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;

@Component
@FeignClient(
        name = "liquidnet-service-platform",
        contextId = "FeignPlatformSmileTaskClient",
        path = "platform",
        url = "${liquidnet.service.platform.url}",
        fallback = FallbackFactory.Default.class
)
public interface FeignPlatformSmileTaskClient {


    @PostMapping("sell/sellData")
    ResponseDto<Boolean> sellData();
    @PostMapping("sell/commissionData")
    ResponseDto<Boolean> commissionData();
}
