package com.liquidnet.service.smile.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.liquidnet.service.smile.entity.SmileSchool;
import com.liquidnet.service.smile.entity.SmileUser;
import com.liquidnet.service.smile.entity.dao.SmileUserCheckDao;
import com.liquidnet.service.smile.entity.dto.SmilePriceIdPhoneDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface SmileUserMapper extends BaseMapper<SmileUser> {

    /**
     * 根据org_id返回符合条件的条数
     * @param id : 组织ID
     * @return
     */
    Integer strip(@Param("orgId")Long id);

    /**
     * 根据id返回用户名
     * @param agentId : 用户id
     * @return
     */
    String selectUserNameById(@Param("id") Long agentId);

    Integer updateUserSchoolBySchoolId(@Param("schoolId") String id,@Param("schoolName") String name);

    List<SmileUser> selectUserList(Map<String, Object> map);

    List<SmileUserCheckDao> selectUserCheck(Map<String, Object> map);

    List<Map> getUserOrder(String userId);

    void updateUserByUid(@Param("uid") String uid,@Param("orgId") Long orgId,@Param("type")Integer tag,@Param("agentId") String agentId);

    void updateUserStateById(@Param("uid") String uid,@Param("state") Integer state,@Param("reason") String reason);

    void updateUserCheckByUid(@Param("uid") String uid,@Param("type") Integer type,@Param("reason") String reason);
    int getCount();
    List<SmileUser> pageUser(@Param("offest") int offest,@Param("size") int size);

    List<SmileUser> getAllUidByPerId(@Param("performancesId") String performancesId);

    List<SmileUser> selectUidByPerId(@Param("performancesId") String performancesId);

    List<SmileUser> selectUidByPerIdNotType(@Param("performancesId") String performancesId);

    List<SmilePriceIdPhoneDao> selectPriceIdPhone(String performanceId);
}
