/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.internal.cache.weaklockfree;

import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.cache.weaklockfree.AbstractWeakConcurrentMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class WeakConcurrentMap<K, V>
extends AbstractWeakConcurrentMap<K, V, LookupKey<K>> {
    private static final ThreadLocal<LookupKey<?>> LOOKUP_KEY_CACHE = new ThreadLocal<LookupKey<?>>(){

        @Override
        protected LookupKey<?> initialValue() {
            return new LookupKey();
        }
    };
    private final boolean reuseKeys;

    public WeakConcurrentMap() {
        this(WeakConcurrentMap.isPersistentClassLoader(LookupKey.class.getClassLoader()));
    }

    private static boolean isPersistentClassLoader(ClassLoader classLoader) {
        try {
            return classLoader == null || classLoader == ClassLoader.getSystemClassLoader() || classLoader == ClassLoader.getSystemClassLoader().getParent();
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public WeakConcurrentMap(boolean reuseKeys) {
        this(reuseKeys, new ConcurrentHashMap());
    }

    public WeakConcurrentMap(boolean reuseKeys, ConcurrentMap<AbstractWeakConcurrentMap.WeakKey<K>, V> target) {
        super(target);
        this.reuseKeys = reuseKeys;
    }

    @Override
    protected LookupKey<K> getLookupKey(K key) {
        LookupKey<Object> lookupKey = this.reuseKeys ? LOOKUP_KEY_CACHE.get() : new LookupKey();
        return lookupKey.withValue(key);
    }

    @Override
    protected void resetLookupKey(LookupKey<K> lookupKey) {
        lookupKey.reset();
    }

    static final class LookupKey<K> {
        @Nullable
        private K key;
        private int hashCode;

        LookupKey() {
        }

        LookupKey<K> withValue(K key) {
            this.key = key;
            this.hashCode = System.identityHashCode(key);
            return this;
        }

        void reset() {
            this.key = null;
            this.hashCode = 0;
        }

        public boolean equals(Object other) {
            if (other instanceof LookupKey) {
                return ((LookupKey)other).key == this.key;
            }
            return ((AbstractWeakConcurrentMap.WeakKey)other).get() == this.key;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    public static class WithInlinedExpunction<K, V>
    extends WeakConcurrentMap<K, V> {
        @Override
        @Nullable
        public V get(K key) {
            WithInlinedExpunction.expungeStaleEntries();
            return (V)super.get((Object)key);
        }

        @Override
        @Nullable
        public V getIfPresent(K key) {
            WithInlinedExpunction.expungeStaleEntries();
            return (V)super.getIfPresent((Object)key);
        }

        @Override
        public boolean containsKey(K key) {
            WithInlinedExpunction.expungeStaleEntries();
            return super.containsKey((Object)key);
        }

        @Override
        public V put(K key, V value) {
            WithInlinedExpunction.expungeStaleEntries();
            return (V)super.put((Object)key, (Object)value);
        }

        @Override
        public V putIfAbsent(K key, V value) {
            WithInlinedExpunction.expungeStaleEntries();
            return (V)super.putIfAbsent((Object)key, (Object)value);
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            WithInlinedExpunction.expungeStaleEntries();
            return (V)super.computeIfAbsent((Object)key, (Function)mappingFunction);
        }

        @Override
        public V remove(K key) {
            WithInlinedExpunction.expungeStaleEntries();
            return (V)super.remove((Object)key);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            WithInlinedExpunction.expungeStaleEntries();
            return super.iterator();
        }

        @Override
        public int approximateSize() {
            WithInlinedExpunction.expungeStaleEntries();
            return super.approximateSize();
        }
    }
}

