package com.liquidnet.service.kylin.service.impl;

import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.kylin.dto.vo.KylinRecommendActiveVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.kylin.entity.KylinRecommendActive;
import com.liquidnet.service.kylin.service.IKylinRecommendActiveService;
import com.liquidnet.service.kylin.utils.DataUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 人流量检测记录表 服务实现类
 * </p>
 *
 */
@Service
public class KylinRecommendActiveServiceImpl implements IKylinRecommendActiveService {
    @Autowired
    private DataUtils dataUtils;

    @Override
    public List<KylinRecommendActiveVo> getRecommendById(List<KylinRecommendActive> list) {
        for(KylinRecommendActive kylinRecommendActive:list){
            KylinRecommendActiveVo kylinRecommendActiveVo = KylinRecommendActiveVo.getNew();
            BeanUtils.copyProperties(kylinRecommendActive,kylinRecommendActiveVo);

            if(StringUtil.isNotBlank(kylinRecommendActiveVo.getActiveBindId())&&null !=kylinRecommendActiveVo.getActiveType()){
                //找到绑定的详情
                if(kylinRecommendActiveVo.getActiveType()==3){
                    //演出
                    KylinPerformanceVo performancesInfo = dataUtils.getPerformanceVo(kylinRecommendActiveVo.getActiveBindId());
                }else if(kylinRecommendActiveVo.getActiveType()==1||kylinRecommendActiveVo.getActiveType()==4){

                }else if(kylinRecommendActiveVo.getActiveType()==2){

                }

            }

        }
        return null;
    }
}
