package com.liquidnet.service.chime.controller;

import com.alibaba.fastjson.JSONObject;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.chime.dto.ChimeUserInfoDto;
import com.liquidnet.service.chime.dto.ChimeUserRegisterReqDto;
import com.liquidnet.service.chime.dto.ChimeUserRegisterRespDto;
import com.liquidnet.service.chime.service.IChimeUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 社交用户控制类
 * @class: ChimeUserController
 * @Package com.liquidnet.service.chime.controller
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/8 15:43
 */
@Api(tags = "在场-用户相关")
@RestController
@RequestMapping("user")
@Validated
@Slf4j
public class ChimeUserController {
    @Autowired
    private IChimeUserService chimeUserService;

    @ApiOperationSupport(order = 5)
    @ApiOperation(value = "社交用户注册")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "userId", value = "用户id"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "nickname", value = "昵称"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "sex", value = "性别"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "tags", value = "兴趣标签(多个用逗号隔开)")
    })
    @PostMapping(value = {"register"})
    public ResponseDto<ChimeUserRegisterRespDto> register(@RequestParam @Validated String userId
            , @RequestParam @Validated String nickname
            , @RequestParam @Validated String sex
            , @RequestParam @Validated String tags
    ) {
        ChimeUserRegisterReqDto reqDto = ChimeUserRegisterReqDto.getNew();
        reqDto.setUserId(userId);
        reqDto.setNickName(nickname);
        reqDto.setSex(sex);
        reqDto.setTags(tags);
        //获取等前登陆用户 CurrentUtil.getCurrentUid()
        JSONObject jsonObject = chimeUserService.register(reqDto);
        if(StringUtil.isNotNull(jsonObject.get("error"))){
            return ResponseDto.failure(jsonObject.get("error").toString());
        }
        ChimeUserRegisterRespDto respDto = ChimeUserRegisterRespDto.getNew();
        respDto = JSONObject.parseObject(jsonObject.toJSONString(),ChimeUserRegisterRespDto.class);

        if(respDto.getActivated()){
            chimeUserService.createChimeUserInfo(reqDto);
        }
        return ResponseDto.success(respDto);
    }

    @ApiOperationSupport(order = 5)
    @ApiOperation(value = "用户兴趣标签修改同步")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "userId", value = "用户id"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "tags", value = "兴趣标签(多个用逗号隔开)")
    })
    @PostMapping(value = {"updateUserTags"})
    public ResponseDto<Boolean> updateUserTags(@RequestParam @Validated String userId
            , @RequestParam @Validated String tags
    ) {
        boolean rs = chimeUserService.updateUserTags(userId,tags);
        return ResponseDto.success(rs);
    }

    @GetMapping("getUserByUserId")
    @ApiOperation("查询单个用户信息")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "userId", value = "用户ID", required = true)
    })
    public ResponseDto<ChimeUserInfoDto> getUserByUserId(
            @RequestParam(defaultValue = "") String userId
    ) {
        ChimeUserInfoDto userInfoDto = chimeUserService.getUserByUserId(userId);
        return ResponseDto.success(userInfoDto);
    }
}
