package com.liquidnet.service.chime.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.common.third.easemob.util.EasemobUtil;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.chime.constant.ChimeConstant;
import com.liquidnet.service.chime.dto.ChimeUserInfoDto;
import com.liquidnet.service.chime.dto.ChimeUserRegisterReqDto;
import com.liquidnet.service.chime.service.IChimeUserService;
import com.liquidnet.service.chime.utils.DataUtils;
import com.liquidnet.service.chime.vo.mongo.ChimeUserInfoVo;
import com.liquidnet.service.chime.vo.mongo.ChimeUserTagsMappingVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ChimeUserServiceImpl
 * @Package com.liquidnet.service.chime.service.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/8 16:17
 */
@Slf4j
@Service
public class ChimeUserServiceImpl implements IChimeUserService {
    @Autowired
    private EasemobUtil easemobUtil;

    @Autowired
    private DataUtils dataUtils;

    @Autowired
    private RedisUtil redisUtil;

    @Override
    public JSONObject register(ChimeUserRegisterReqDto reqDto) {
        String result = easemobUtil.createUser(reqDto.getUserId(),"123456",reqDto.getNickName());
        log.info("chime easemobUtil.createUser result:{}",result);
        JSONObject jsonObject = JSONObject.parseObject(result);
        return jsonObject;
    }

    @Override
    public ChimeUserInfoDto createChimeUserInfo(ChimeUserRegisterReqDto reqDto) {
        String rk = AdamRedisConst.INFO_USER.concat(CurrentUtil.getCurrentUid());
        AdamUserInfoVo vo = (AdamUserInfoVo) redisUtil.get(rk);

        ChimeUserInfoVo chimeUserInfoVo = ChimeUserInfoVo.getNew();
        chimeUserInfoVo.setMid(ChimeConstant.getNewUserId());
        chimeUserInfoVo.setUserId(reqDto.getUserId());
        if(StringUtil.isNotNull(vo.getSex())){
            chimeUserInfoVo.setSex(vo.getSex().getDesc());
        }else{
            chimeUserInfoVo.setSex("");
        }
        chimeUserInfoVo.setUserName(vo.getUid());
        chimeUserInfoVo.setUserMobile(vo.getMobile());
        chimeUserInfoVo.setAvatar(vo.getAvatar());
        chimeUserInfoVo.setJoinPerformanceId("-1");


//
//        AdamTagVo sex = vo.getSex();
//        if (null == sex) {
//            return ResponseDto.failure(ErrorMapping.get("10011"));
//        }
//        if (null != sex) {
//            String sexVal = sex.getVal();
//            List<AdamTagVo> allSexTagVos = this.getTagsForSex().getData();
//            Optional<AdamTagVo> existSexTagVoOptional = allSexTagVos.stream().filter(r -> r.getVal().equals(sexVal)).findAny();
//            if (!existSexTagVoOptional.isPresent()) {
//                // 已选中的性别标签不在系统性别标签库中
//                return ResponseDto.failure(ErrorMapping.get("10011"));
//            }
//            sex = existSexTagVoOptional.get();
//        }

        //插入mongo
        dataUtils.createChimeUser(chimeUserInfoVo);

        //插入userTagMapping
        List<ChimeUserTagsMappingVo> userTagList = new ArrayList<>();
        if(StringUtil.isNotEmpty(reqDto.getTags())){
            List<String> list = Arrays.asList(reqDto.getTags().split(","));
            for(String tagCode:list){
                ChimeUserTagsMappingVo tempvo = ChimeUserTagsMappingVo.getNew();
                tempvo.setUserId(reqDto.getUserId());
                tempvo.setTagCode(tagCode);
                tempvo.setTagDesc("描述"+tagCode);
                userTagList.add(tempvo);
            }
        }
        dataUtils.createUserTagMapping(userTagList);
        return null;
    }

    @Override
    public boolean updateUserTags(String userId,String tags) {
        //插入userTagMapping
        List<ChimeUserTagsMappingVo> userTagList = new ArrayList<>();
        if(StringUtil.isNotEmpty(tags)){
            List<String> list = Arrays.asList(tags.split(","));
            for(String tagCode:list){
                ChimeUserTagsMappingVo tempvo = ChimeUserTagsMappingVo.getNew();
                tempvo.setUserId(userId);
                tempvo.setTagCode(tagCode);
                tempvo.setTagDesc("描述"+tagCode);
                userTagList.add(tempvo);
            }
        }
        return dataUtils.updateUserTagMapping(userId,userTagList);
    }

    @Override
    public ChimeUserInfoDto getUserByUserId(String userId) {
        ChimeUserInfoVo chimeUserInfoVo = dataUtils.getUserByUserId(userId);
        if(StringUtil.isNotNull(chimeUserInfoVo)){
            ChimeUserInfoDto chimeUserInfoDto = ChimeUserInfoDto.getNew();
            BeanUtil.copy(chimeUserInfoVo,chimeUserInfoDto);
            chimeUserInfoDto.setPassWord("123456");
            //获取标签
            chimeUserInfoDto.setUserTags(dataUtils.getUserTagList(userId));
            return chimeUserInfoDto;
        }
        return null;
    }
}
