package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyNftPublishAndBuyRespDto
 * @Package com.liquidnet.service.galaxy.dto.param;
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/3/17 13:51
 */
@ApiModel(value = "GalaxyNftPublishAndBuyRespDto", description = "NFT购买")
@Data
public class GalaxyNftPublishAndBuyRespDto implements Serializable,Cloneable {
    @ApiModelProperty(position = 1, required = true, value = "用户Id")
    private String userId;

    @ApiModelProperty(position = 1, required = true, value = "用户购买的nftId")
    private String nftId;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftPublishAndBuyRespDto obj = new GalaxyNftPublishAndBuyRespDto();

    public static GalaxyNftPublishAndBuyRespDto getNew() {
        try {
            return (GalaxyNftPublishAndBuyRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftPublishAndBuyRespDto();
        }
    }
}
