package com.liquidnet.service.goblin.mapper;

import com.liquidnet.service.goblin.entity.GoblinNftExCodeTask;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import lombok.experimental.PackagePrivate;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * <p>
 *  Mapper 接口
 * </p>
 *
 * @author wanglele
 * @since 2022-04-27
 */
@Repository
public interface GoblinNftExCodeTaskMapper extends BaseMapper<GoblinNftExCodeTask> {

    /**
     * 获取所有定时任务
     * @return
     */
    List<GoblinNftExCodeTask> selectByActivity();

    /**
     * 批量添加定时任务
     * @param goblinNftExCodeTasks
     * @return
     */
    int addGoblinNftExCodeTasks(@Param("goblinNftExCodeTasks") List<GoblinNftExCodeTask> goblinNftExCodeTasks);

    /**
     * 批量删除定时
     * @param taskIds
     * @return
     */
    int deleteByTaskIds(@Param("taskIds") String taskIds);

    /**
     * 批量修改定时
     * @param taskIds
     * @return
     */
    int updateByTaskIds(@Param("taskIds") String taskIds);

    /**
     * 根据活动ids获取定时
     * @param activityIds
     * @return
     */
    List<GoblinNftExCodeTask> selectByActivityIds(@Param("activityIds") String activityIds);
}
