package com.liquidnet.service.galaxy.dto.bo;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 用户注册信息
 * @class: GalaxyUserInfoBo
 * @Package com.liquidnet.service.galaxy
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/15 14:34
 */
@Data
public class GalaxyUserInfoBo implements Serializable,Cloneable{
    private String userId;
    private String userName;
    private String mobile;
    private String idCardType;
    private String idCard;
    private String mnemonic;
    private String index;
    private String userIdentification;
    private String userPubKey;
    private String userPriKey;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyUserInfoBo obj = new GalaxyUserInfoBo();

    public static GalaxyUserInfoBo getNew() {
        try {
            return (GalaxyUserInfoBo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyUserInfoBo();
        }
    }
}

