package com.liquidnet.service.feign.adam.api;

import com.liquidnet.service.adam.dto.rsc.AdamChimeUinfoDto;
import com.liquidnet.service.adam.dto.vo.*;
import com.liquidnet.service.adam.dto.rsc.AdamChimeUinfoReq;
import com.liquidnet.service.adam.dto.vo.AdamAddressesVo;
import com.liquidnet.service.adam.dto.vo.AdamEntersVo;
import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import java.util.List;

@Component
@FeignClient(name = "liquidnet-service-adam",
        contextId = "FeignAdamBaseClient", path = "adam",
        url = "http://127.0.0.1:9001",
        fallback = FallbackFactory.Default.class)
public interface FeignAdamBaseClient {

    @GetMapping("enters/query/depth")
    ResponseDto<AdamEntersVo> queryEnters(@RequestParam("entersId") String entersId,
                                          @RequestParam("uid") String uid);

    @GetMapping("addr/query/depth")
    ResponseDto<AdamAddressesVo> queryAddresses(@RequestParam(value = "addrId") String addrId,
                                                @RequestParam(value = "uid") String uid);

    @PostMapping("rsc/inquire/cuinfo")
    ResponseDto<List<AdamChimeUinfoDto>> queryForChimeUserInfo(@RequestBody AdamChimeUinfoReq req);

    @PostMapping("rsc/inquire/sendMsgToRedis")
    ResponseDto<Boolean> sendMsgToRedis(@RequestParam("redisKey") String redisKey,@RequestParam("jsonParamStr") String jsonParamStr);

    @PostMapping(value = {"rsc/reg/mobile"})
    ResponseDto<AdamUserInfoVo> registerByMobile(@Pattern(regexp = "\\d{11}", message = "手机号格式有误")
                                                        @RequestParam(value = "mobile") String mobile);

    @PostMapping(value = {"login/silent_mobile"})
    ResponseDto<AdamLoginInfoVo> loginBySilentMobile(@Pattern(regexp = "\\d{11}", message = "手机号格式有误")
                                                    @NotBlank(message = "手机号不能为空")
                                                    @RequestParam(value = "mobile") String mobile,
                                                     @NotBlank(message = "临时票据不能为空")
                                                    @RequestParam(value = "otp") String otp);
}
