package com.liquidnet.service.goblin.controller.manage;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreGoodsCategoryVo;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreMgtCategoryService;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.ObjectUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import java.util.ArrayList;
import java.util.List;

@ApiSupport(order = 149005)
@Api(tags = "店铺商品分类管理")
@Slf4j
@Validated
@RestController
@RequestMapping("store/mgt/category")
public class GoblinStoreMgtCategoryController {
    @Autowired
    IGoblinStoreMgtCategoryService goblinStoreMgtCategoryService;
    @Autowired
    GoblinRedisUtils goblinRedisUtils;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "店铺ID[64]"),
    })
    @GetMapping("list")
    public ResponseDto<List<GoblinStoreGoodsCategoryVo>> list(@NotBlank(message = "店铺ID不能为空") @RequestParam String storeId) {
        List<GoblinStoreGoodsCategoryVo> storeGoodsCategoryVos = goblinStoreMgtCategoryService.list(storeId);
        storeGoodsCategoryVos.clear();// TODO: 2022/1/12 zhanggb del
        storeGoodsCategoryVos.add(
                GoblinStoreGoodsCategoryVo.getNew().setCateId("10000").setName("1级").setSort(1).setGrade("1").setNeIsbn("0")
        );
        storeGoodsCategoryVos.add(
                GoblinStoreGoodsCategoryVo.getNew().setCateId("10100").setName("2级").setSort(1).setGrade("2").setNeIsbn("0").setCatePid("10000")
        );
        storeGoodsCategoryVos.add(
                GoblinStoreGoodsCategoryVo.getNew().setCateId("10101").setName("3级").setSort(1).setGrade("3").setNeIsbn("1").setCatePid("10100")
        );
        return ResponseDto.success(storeGoodsCategoryVos);
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "添加")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "店铺ID[64]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "catefid", value = "平台一级分类ID[30]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "catesid", value = "平台二级分类ID[30]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "catetid", value = "平台三级分类ID[30]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "catename", value = "店铺三级分类名称[50]"),
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "sort", value = "排序[数值越小,排序越前]"),
    })
    @GetMapping("add")
    public ResponseDto<Object> add(@NotBlank(message = "店铺ID不能为空") @RequestParam String storeId,
                                   @NotBlank(message = "平台一级分类ID不能为空") @RequestParam String catefid,
                                   @NotBlank(message = "平台二级分类不能为空") @RequestParam String catesid,
                                   @NotBlank(message = "平台三级分类不能为空") @RequestParam String catetid,
                                   @NotBlank(message = "店铺三级分类名称不能为空") @RequestParam String catename,
                                   @Min(value = 0, message = "排序不能小于0") @RequestParam Integer sort) {
        String currentUid = CurrentUtil.getCurrentUid();
        if (!goblinRedisUtils.hasStoreId(currentUid, storeId)) {
            return ResponseDto.failure(ErrorMapping.get("149002"));
        }
        // TODO: 2022/1/11 zhanggb 逻辑校验，数据整理
        String catefname = "1级分类", catesname = "2级分类", catefgrade = "1", catesgrade = "2";
        int catefsort = 1, catessort=1;

        ArrayList<GoblinStoreGoodsCategoryVo> storeGoodsCategoryVoList = ObjectUtil.getGoblinStoreGoodsCategoryVoArrayList();
        storeGoodsCategoryVoList.add(GoblinStoreGoodsCategoryVo.getNew().setStoreId(storeId).setCateId(catefid).setName(catefname)
                .setSort(catefsort).setGrade(catefgrade).setCatePid(null));
        storeGoodsCategoryVoList.add(GoblinStoreGoodsCategoryVo.getNew().setStoreId(storeId).setCateId(catesid).setName(catesname)
                .setSort(catessort).setGrade(catesgrade).setCatePid(catefid));
        storeGoodsCategoryVoList.add(GoblinStoreGoodsCategoryVo.getNew().setStoreId(storeId).setCateId(IDGenerator.nextMilliId2()).setName(catename)
                .setSort(null == sort ? 0 : sort).setGrade("3").setCatePid(catesid));
        return ResponseDto.success(goblinStoreMgtCategoryService.add(currentUid, storeGoodsCategoryVoList));
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "编辑")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "店铺ID[64]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "cateid", value = "平台三级分类ID[30]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "catename", value = "店铺三级分类名称[50]"),
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "sort", value = "排序[数值越小,排序越前]"),    })
    @GetMapping("edit")
    public ResponseDto<Object> edit(@NotBlank(message = "店铺ID不能为空") @RequestParam String storeId,
                                    @NotBlank(message = "店铺三级分类ID不能为空") @RequestParam String cateid,
                                    @NotBlank(message = "店铺三级分类名称不能为空") @RequestParam String catename,
                                    @Min(value = 0, message = "排序不能小于0") @RequestParam Integer sort) {
        String currentUid = CurrentUtil.getCurrentUid();
        if (!goblinRedisUtils.hasStoreId(currentUid, storeId)) {
            return ResponseDto.failure(ErrorMapping.get("149002"));
        }
        GoblinStoreGoodsCategoryVo storeGoodsCategoryVo = GoblinStoreGoodsCategoryVo.getNew()
                .setStoreId(storeId).setCateId(cateid).setName(catename).setSort(sort);
        return ResponseDto.success(goblinStoreMgtCategoryService.edit(currentUid, storeGoodsCategoryVo));
    }

    @ApiOperationSupport(order = 4)
    @ApiOperation(value = "删除")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "店铺ID[64]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "cateid", value = "店铺三级分类ID[30]"),
    })
    @GetMapping("del")
    public ResponseDto<Object> del(@NotBlank(message = "店铺ID不能为空") @RequestParam String storeId,
                                   @NotBlank(message = "店铺三级分类ID不能为空") @RequestParam String cateid) {
        String currentUid = CurrentUtil.getCurrentUid();
        if (!goblinRedisUtils.hasStoreId(currentUid, storeId)) {
            return ResponseDto.failure(ErrorMapping.get("149002"));
        }
        return ResponseDto.success(goblinStoreMgtCategoryService.del(currentUid, storeId, cateid));
    }
}
