package com.liquidnet.service.goblin.service.impl.manage;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreInfoVo;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreMgtService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.QueueUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.LinkedList;

@Service
public class GoblinStoreMgtServiceImpl implements IGoblinStoreMgtService {
    @Autowired
    private QueueUtils queueUtils;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;
    @Autowired
    private GoblinMongoUtils goblinMongoUtils;

    @Override
    public boolean updateStoreMgtInfo(GoblinStoreInfoVo storeInfoVo) {
        if (goblinMongoUtils.updateStoreInfoVo(storeInfoVo)) {
            // TODO: 2022/1/12 zhanggb redis

            queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_STORE.getKey(),
                    SqlMapping.get("goblin_store_info.update_by_edit",
                            storeInfoVo.getStoreName(), storeInfoVo.getLogoPic(), storeInfoVo.getBackgroundPic(), storeInfoVo.getIntroduce(),
                            storeInfoVo.getUpdatedBy(), storeInfoVo.getUpdatedAt(), storeInfoVo.getStoreId()
                    ));
            return true;
        }
        return false;
    }
}
