package com.liquidnet.service.goblin.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.commons.lang.util.RandomUtil;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.dto.vo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Component
public class GoblinRedisUtils {
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    GoblinMongoUtils goblinMongoUtils;

    private int randomMax = 10;


    /* ---------------------------------------- sku库存相关 ---------------------------------------- */
    public void setSkuStock(String marketPre, String skuId, Integer stock) {
        String rk = GoblinRedisConst.REAL_STOCK_SKU;
        if (marketPre != null) {
            rk = rk.concat(marketPre + ":");
        }
        rk = rk.concat(skuId);
        redisUtil.set(rk, stock);
    }

    public int getSkuStock(String marketPre, String skuId) {
        String rk = GoblinRedisConst.REAL_STOCK_SKU;
        if (marketPre != null && !marketPre.equals("null")) {
            rk = rk.concat(marketPre + ":");
        }
        rk = rk.concat(skuId);
        Object obj = redisUtil.get(rk);
        if (obj == null) {
            return 0;
        } else {
            return (int) obj;
        }
    }

    public int incrSkuStock(String marketPre, String skuId, Integer stock) {
        String rk = GoblinRedisConst.REAL_STOCK_SKU;
        if (marketPre != null && !marketPre.equals("null")) {
            rk = rk.concat(marketPre + ":");
        }
        rk = rk.concat(skuId);
        return (int) redisUtil.incr(rk, stock);
    }

    public int decrSkuStock(String marketPre, String skuId, Integer stock) {
        String rk = GoblinRedisConst.REAL_STOCK_SKU;
        if (marketPre != null && !marketPre.equals("null")) {
            rk = rk.concat(marketPre + ":");
        }
        rk = rk.concat(skuId);
        return (int) redisUtil.decr(rk, stock);
    }

    /* ---------------------------------------- 平台分类数据源 ---------------------------------------- */

    public List<GoblinSelfGoodsCategoryVo> getSelfGoodsCategoryVos() {
        ArrayList<GoblinSelfGoodsCategoryVo> selfGoodsCategoryVoList = ObjectUtil.getGoblinSelfGoodsCategoryVoArrayList();
        selfGoodsCategoryVoList.add(GoblinSelfGoodsCategoryVo.getNew().setCateId("10000").setName("一级分类").setSort(1)
                .setCatePid(null).setGrade("1").setNeIsbn("0").setIcon("https://img.zhengzai.tv/files/2020/08/31/5f4c75095e9bc.png"));
        selfGoodsCategoryVoList.add(GoblinSelfGoodsCategoryVo.getNew().setCateId("10100").setName("二级分类").setSort(1)
                .setCatePid("10000").setGrade("2").setNeIsbn("0").setIcon("https://img.zhengzai.tv/files/2020/08/31/5f4c75095e9bc.png"));
        selfGoodsCategoryVoList.add(GoblinSelfGoodsCategoryVo.getNew().setCateId("10101").setName("三级分类").setSort(1)
                .setCatePid("10100").setGrade("3").setNeIsbn("1").setIcon("https://img.zhengzai.tv/files/2020/08/31/5f4c75095e9bc.png"));
        return selfGoodsCategoryVoList;
    }
    /* ---------------------------------------- 店铺分类数据源 ---------------------------------------- */

    public List<GoblinStoreGoodsCategoryVo> getStoreGoodsCategoryVos(String storeId) {
        String rk = GoblinRedisConst.BASIC_STORE_GOODS_CATEGORY.concat(storeId);
        String valStr = (String) redisUtil.get(rk);
        boolean valStrIsEmptyFlg = StringUtils.isEmpty(valStr);
        List<GoblinStoreGoodsCategoryVo> vos = null;
        if (valStrIsEmptyFlg && !CollectionUtils.isEmpty(vos = goblinMongoUtils.getStoreGoodsCategoryVos(storeId))) {
            valStr = JsonUtils.toJson(vos);
//            redisUtil.set(rk, valStr);// TODO: 2022/1/11 zhanggb 暂不启用
        } else if (!valStrIsEmptyFlg) {
            vos = JsonUtils.fromJson(valStr, new TypeReference<List<GoblinStoreGoodsCategoryVo>>() {
            });
        }
        return vos;
    }

    /* ---------------------------------------- 店铺配置数据源 ---------------------------------------- */

    public List<GoblinStoreConfigVo> getStoreConfigVos(String storeId) {
        String rk = GoblinRedisConst.BASIC_STORE_CONF.concat(storeId);
        List<GoblinStoreConfigVo> vos = (List<GoblinStoreConfigVo>) redisUtil.get(rk);
        if (CollectionUtils.isEmpty(vos) && null != (vos = goblinMongoUtils.getStoreConfigVo(storeId))) {
//            redisUtil.set(rk, vos);// TODO: 2022/1/12 zhanggb 暂不设置
        }
        return vos;
    }

    /* ---------------------------------------- 店铺数据源 ---------------------------------------- */

    private boolean setStoreIds(String uid, List<String> storeIds) {
        return redisUtil.set(GoblinRedisConst.BASIC_USTORE.concat(uid), storeIds);
    }

    public boolean addStoreId(String uid, String storeId) {
        List<String> storeIds = this.getStoreIds(uid);
//        if (CollectionUtils.isEmpty(storeIds)) {
        if (CollectionUtils.isEmpty(storeIds) || storeIds.contains("1")) {// TODO: 2022/1/6 zhanggb del
            storeIds = CollectionUtil.arrayListString();
        }
        storeIds.add(storeId);
        return this.setStoreIds(uid, storeIds);
    }

    public void delStoreIds(String uid) {
        redisUtil.del(GoblinRedisConst.BASIC_USTORE.concat(uid));
    }

    public void delStoreId(String uid, String storeId) {
        List<String> storeIds = this.getStoreIds(uid);
        if (!CollectionUtils.isEmpty(storeIds)) {
            storeIds.removeIf(r -> r.equals(storeId));
            this.setStoreIds(uid, storeIds);
        }
    }

    public List<String> getStoreIds(String uid) {
//        return (List<String>) redisUtil.get(GoblinRedisConst.BASIC_USTORE.concat(uid));
//        return Arrays.asList("1");// TODO: 2022/1/5 zhanggb
        List<String> list = (List<String>) redisUtil.get(GoblinRedisConst.BASIC_USTORE.concat(uid));
        return CollectionUtils.isEmpty(list) ? Arrays.asList("1") : list;
    }

    public boolean hasStoreId(String uid, String storeId) {
        List<String> list = this.getStoreIds(uid);
        return !CollectionUtils.isEmpty(list) && list.contains(storeId);
    }

    public boolean setStoreInfoVo(GoblinStoreInfoVo vo) {
        List<String> storeIds = this.getStoreIds(vo.getUid());
        if (CollectionUtils.isEmpty(storeIds)) {
            storeIds = CollectionUtil.arrayListString();
        }
        storeIds.add(vo.getStoreId());
        this.setStoreIds(vo.getUid(), storeIds);
        return redisUtil.set(GoblinRedisConst.BASIC_STORE.concat(vo.getStoreId()), vo);
    }

    public void delStoreInfoVo(String storeId) {
        redisUtil.del(GoblinRedisConst.BASIC_STORE.concat(storeId));
    }

    public GoblinStoreInfoVo getStoreInfoVo(String storeId) {
        String rk = GoblinRedisConst.BASIC_STORE.concat(storeId);
        GoblinStoreInfoVo vo = (GoblinStoreInfoVo) redisUtil.get(rk);
        if (null == vo && null != (vo = goblinMongoUtils.getStoreInfoVo(storeId))) {
//            redisUtil.set(rk, vo);// TODO: 2022/1/4 zhanggb:暂不设置
        }
        return vo;
    }

    public GoblinStoreInfoVo getStoreInfoVoByUid(String uid) {
        List<String> storeIds = this.getStoreIds(uid);
        return CollectionUtils.isEmpty(storeIds) ? goblinMongoUtils.getStoreInfoVoByUid(uid) : this.getStoreInfoVo(storeIds.get(0));
    }

    /* ---------------------------------------- 商品数据源 ---------------------------------------- */

    public boolean setGoodsInfoVo(GoblinGoodsInfoVo vo) {
        return redisUtil.set(GoblinRedisConst.BASIC_GOODS.concat(vo.getSpuId()), vo);
    }

    public void delGoodsInfoVo(String spuId) {
        redisUtil.del(GoblinRedisConst.BASIC_GOODS.concat(spuId));
    }

    /**
     * 商品基础信息
     *
     * @param spuId 商品ID
     * @return GoblinGoodsInfoVo
     */
    public GoblinGoodsInfoVo getGoodsInfoVo(String spuId) {
        String rk = GoblinRedisConst.BASIC_GOODS.concat(spuId);
        GoblinGoodsInfoVo vo = (GoblinGoodsInfoVo) redisUtil.get(rk);
        if (null == vo && null != (vo = goblinMongoUtils.getGoodsInfoVo(spuId))) {
//            redisUtil.set(rk, vo);// TODO: 2022/1/4 zhanggb:暂不设置

            vo = !vo.getDelFlg().equals("0") ? null : vo;
        }
        return vo;
    }

    public GoblinGoodsInfoVo getMgtGoodsInfoVo(String spuId) {
        String rk = GoblinRedisConst.BASIC_GOODS.concat(spuId);
        GoblinGoodsInfoVo vo = (GoblinGoodsInfoVo) redisUtil.get(rk);
        if (null == vo && null != (vo = goblinMongoUtils.getMgtGoodsInfoVo(spuId))) {
//            redisUtil.set(rk, vo);// TODO: 2022/1/4 zhanggb:暂不设置
        }
        return vo;
    }

    public boolean setGoodsSkuInfoVo(GoblinGoodsSkuInfoVo vo) {
        return redisUtil.set(GoblinRedisConst.BASIC_GOODS_SKU.concat(vo.getSkuId()), vo);
    }

    public void delGoodsSkuInfoVo(String skuId) {
        redisUtil.del(GoblinRedisConst.BASIC_GOODS_SKU.concat(skuId));
    }

    /**
     * 单品信息
     *
     * @param skuId 单品ID
     * @return GoblinGoodsSkuInfoVo
     */
    public GoblinGoodsSkuInfoVo getGoodsSkuInfoVo(String skuId) {
        String rk = GoblinRedisConst.BASIC_GOODS_SKU.concat(skuId);
        GoblinGoodsSkuInfoVo vo = (GoblinGoodsSkuInfoVo) redisUtil.get(rk);
        if (null == vo && null != (vo = goblinMongoUtils.getGoodsSkuInfoVo(skuId))) {
//            redisUtil.set(rk, vo);// TODO: 2022/1/4 zhanggb:暂不设置

            vo = !vo.getDelFlg().equals("0") ? null : vo;
        }
        return vo;
    }

    public GoblinGoodsSkuInfoVo getMgtGoodsSkuInfoVo(String skuId) {
        String rk = GoblinRedisConst.BASIC_GOODS_SKU.concat(skuId);
        GoblinGoodsSkuInfoVo vo = (GoblinGoodsSkuInfoVo) redisUtil.get(rk);
        if (null == vo && null != (vo = goblinMongoUtils.getMgtGoodsSkuInfoVo(skuId))) {
//            redisUtil.set(rk, vo);// TODO: 2022/1/4 zhanggb:暂不设置
        }
        return vo;
    }


    /* ----------------------------------------  ---------------------------------------- */

    /**
     * 覆盖 商铺活动vo
     *
     * @param storeMarketId
     * @param vo
     * @return
     */
    public boolean setGoblinStoreMarketVo(String storeMarketId, GoblinStoreMarketVo vo) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_STORE_MARKET.concat(storeMarketId);
        return redisUtil.set(redisKey, vo);
    }

    /**
     * 获取 商铺活动vo
     *
     * @param storeMarketId
     * @return
     */
    public GoblinStoreMarketVo getGoblinStoreMarketVo(String storeMarketId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_STORE_MARKET.concat(storeMarketId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            GoblinStoreMarketVo vo = goblinMongoUtils.getStoreMarket(storeMarketId);
            setGoblinStoreMarketVo(storeMarketId, vo);
            return vo;
        } else {
            return (GoblinStoreMarketVo) obj;
        }
    }

    /**
     * 删除 商铺活动vo
     *
     * @param storeMarketId
     * @return
     */
    public void delGoblinStoreMarketVo(String storeMarketId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_STORE_MARKET.concat(storeMarketId);
        redisUtil.del(redisKey);
    }


    /**
     * 获取 配置的商铺id
     *
     * @param marketId
     * @param storeId
     */
    public List<GoblinStoreMarketIsConfigVo> getStoreMarketIsConfig(String marketId, String storeId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_STORE_MARKET_ISCONFIG.concat(marketId).concat(":store_id:" + storeId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return new ArrayList();
        } else {
            return (List<GoblinStoreMarketIsConfigVo>) obj;
        }
    }

    public void addStoreMarketIsConfig(String marketId, String storeId, String spuId, String marketSpuId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_STORE_MARKET_ISCONFIG.concat(marketId).concat(":store_id:" + storeId);
        List<GoblinStoreMarketIsConfigVo> voList = getStoreMarketIsConfig(marketId, storeId);
        GoblinStoreMarketIsConfigVo vo = GoblinStoreMarketIsConfigVo.getNew();
        vo.setMarketSpuId(marketSpuId);
        vo.setSpuId(spuId);
        voList.add(vo);
        redisUtil.set(redisKey, voList);
    }

    public void delStoreMarketIsConfig(String marketId, String storeId, String spuId, String marketSpuId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_STORE_MARKET_ISCONFIG.concat(marketId).concat(":store_id:" + storeId);
        List<GoblinStoreMarketIsConfigVo> voList = getStoreMarketIsConfig(marketId, storeId);
        for (int i = 0; i < voList.size(); i++) {
            String itemSpuId = voList.get(i).getSpuId();
            if (spuId.equals(itemSpuId)) {
                voList.remove(i);
            }
        }
        redisUtil.set(redisKey, voList);
    }

    /**
     * 添加 活动内商品款式关联关系
     *
     * @param marketPre
     * @param marketId
     * @param vo
     */
    public void addMarketRelation(String marketPre, String marketId, GoblinMarketRelationVo vo) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_MARKET_RELATION.concat(marketPre).concat(marketId);
        List<GoblinMarketRelationVo> voList = getMarketRelation(marketPre, marketId);
        voList.add(vo);
        redisUtil.set(redisKey, voList);
    }

    /**
     * 移除 活动内商品款式关联关系
     *
     * @param marketPre
     * @param marketId
     */
    public void removeMarketRelation(String marketPre, String marketId, String spuId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_MARKET_RELATION.concat(marketPre).concat(marketId);
        List<GoblinMarketRelationVo> voList = getMarketRelation(marketPre, marketId);
        for (GoblinMarketRelationVo item : voList) {
            if (item.getSpuId().equals(spuId)) {
                voList.remove(item);
                break;
            }
        }
        redisUtil.set(redisKey, voList);
    }

    /**
     * 获取 活动内商品款式关联关系
     *
     * @param marketPre
     * @param marketId
     */
    public List<GoblinMarketRelationVo> getMarketRelation(String marketPre, String marketId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_MARKET_RELATION.concat(marketPre).concat(marketId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return new ArrayList();
        } else {
            return (List<GoblinMarketRelationVo>) obj;
        }
    }

    /**
     * 获取 当前商铺能参与的官方活动id列表
     *
     * @param storeId
     * @return
     */
    public List<String> getStoreZhengzaiRelation(String storeId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_STORE_SELF_RELATION.concat(storeId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return (List<String>) obj;
        }
    }

    /**
     * 正在下单 可参加商户关系 详情
     *
     * @param selfMarketId
     * @param storeId
     */
    public GoblinMarketingZhengzaiRelationVo getZhengzaiRelation(String selfMarketId, String storeId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ZHENGZAI_RELATION.concat(selfMarketId).concat(":store_id:" + storeId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return (GoblinMarketingZhengzaiRelationVo) obj;
        }
    }

    /**
     * 正在下单 可参加商户 详情
     *
     * @param selfMarketId
     */
    public GoblinSelfMarketingVo getSelfMarket(String selfMarketId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_SELF_MARKET.concat(selfMarketId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return (GoblinSelfMarketingVo) obj;
        }
    }

    //获取全部正在下单的活动
    public List<GoblinSelfMarketingVo> getGoblinSelfMarketingVoList() {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ZHENGZAI_LIST;
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return goblinMongoUtils.getGoblinSelfMarketingVoList();
        } else {
            return (List<GoblinSelfMarketingVo>) obj;
        }
    }

    //获取 用户sku购买个数
    public Integer getSkuCountByUid(String uid, String skuId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_BUY_COUNT.concat(uid + ":skuId:" + skuId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return (Integer) obj;
        }
    }

    // 增加 用户sku购买个数
    public int incrSkuCountByUid(String uid, String skuId, int number) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_BUY_COUNT.concat(uid + ":skuId:" + skuId);
        return (int) redisUtil.incr(redisKey, number);
    }

    // 减少 用户sku购买个数
    public int decrSkuCountByUid(String uid, String skuId, int number) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_BUY_COUNT.concat(uid + ":skuId:" + skuId);
        return (int) redisUtil.decr(redisKey, number);
    }

    //获取 sku销量
    public Integer getSkuSaleCount(String skuId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_SALE_COUNT.concat(skuId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return (Integer) obj;
        }
    }

    // 增加 sku销量
    public int incrSkuSaleCount(String skuId, int number) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_SALE_COUNT.concat(skuId);
        return (int) redisUtil.incr(redisKey, number);
    }

    // 减少 sku销量
    public int decrSkuSaleCount(String skuId, int number) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_SALE_COUNT.concat(skuId);
        return (int) redisUtil.decr(redisKey, number);
    }

    // 赋值 订单相关vo
    public void setGoblinOrder(String orderId, GoblinStoreOrderVo vo) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ORDER.concat(orderId);
        redisUtil.set(redisKey, vo);
    }


    // 赋值 订单相关Skuvo
    public void setGoblinOrderSku(String orderSkuId, GoblinOrderSkuVo vo) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ORDER_SKU.concat(orderSkuId);
        redisUtil.set(redisKey, vo);
    }

    // 获取 订单相关vo
    public GoblinStoreOrderVo getGoblinOrder(String orderId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ORDER.concat(orderId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return (GoblinStoreOrderVo) obj;
        }
    }

    // 获取 订单相关Skuvo
    public GoblinOrderSkuVo getGoblinOrderSkuVo(String orderSkuId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ORDER_SKU.concat(orderSkuId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return (GoblinOrderSkuVo) obj;
        }
    }

    // 获取 未支付订单id列表
    public List<String> getUnPayOrder(String randomKey) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ORDER_UN_PAY.concat(randomKey);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return CollectionUtil.arrayListString();
        } else {
            return (List<String>) obj;
        }
    }

    // 添加 未支付订单id列表
    public void addUnPayOrder(String orderId) {
        int randomKey = RandomUtil.getRandomInt(0, randomMax);
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ORDER_UN_PAY.concat(randomKey + "");
        List<String> list = getUnPayOrder(randomKey + "");
        list.add(orderId);
        redisUtil.set(redisKey, list);
    }

    // 删除 未支付订单id列表
    public void removeGoblinOrder(String randomKey, String orderId) {
        if (randomKey == null) {
            for (int i = 0; i < randomMax; i++) {
                String redisKey = GoblinRedisConst.REDIS_GOBLIN_ORDER_UN_PAY.concat(i + "");
                List<String> list = getUnPayOrder(randomKey);
                if (list.contains(orderId)) {
                    list.remove(orderId);
                    redisUtil.set(redisKey, list);
                    break;
                }
            }
        } else {
            String redisKey = GoblinRedisConst.REDIS_GOBLIN_ORDER_UN_PAY.concat(randomKey + "");
            List<String> list = getUnPayOrder(randomKey);
            list.remove(orderId);
            redisUtil.set(redisKey, list);
        }
    }

    // 获取 订单id列表
    public List<String> getOrderList(String uid) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ORDER_LIST.concat(uid);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return CollectionUtil.arrayListString();
        } else {
            return (List<String>) obj;
        }
    }

    // 添加 订单id列表
    public void addOrderList(String uid, String orderId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ORDER_LIST.concat(uid);
        List<String> list = getOrderList(uid);
        list.add(orderId);
        redisUtil.set(redisKey, list);
    }

    // 删除 订单id列表
    public void removeOrderList(String uid, String orderId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ORDER_LIST.concat(uid);
        List<String> list = getOrderList(uid);
        list.remove(orderId);
        redisUtil.set(redisKey, list);
    }


    //主订单下包含的子订单
    public void setMasterCode(String masterCode, String orderIds) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ORDER_MASTER.concat(masterCode);
        redisUtil.set(redisKey, orderIds);
    }

    public String[] getMasterCode(String masterCode) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ORDER_MASTER.concat(masterCode);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return ((String) obj).split(",");
        }
    }

    //覆盖 退款订单vo
    public void setBackOrderVo(String backOrderId, GoblinBackOrderVo vo) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ORDER_BACK.concat(backOrderId);
        redisUtil.set(redisKey, vo);
    }

    //覆盖 获取订单vo
    public GoblinBackOrderVo getBackOrderVo(String backOrderId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ORDER_BACK.concat(backOrderId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return (GoblinBackOrderVo) obj;
        }
    }
}
