package com.liquidnet.service.kylin.service.impl;

import com.github.pagehelper.PageInfo;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.adam.dto.vo.admin.AdminUpushVo;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.LinkedList;

/**
 * <p>
 * 轮播图 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-02
 */
@Service
public class KylinUpushServiceImpl {

    @Value("${liquidnet.aliyun.oss.imgUrl}")
    private String imgUrl;

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    private RedisUtil redisUtil;

    public PageInfo<AdminUpushVo> lists(HttpServletRequest request, Integer page, Integer size) {
        String uid = CurrentUtil.getCurrentUid();
        String source = request.getHeader("source");
        PageInfo<AdminUpushVo> voPageInfo = null;
        Object adminUpushVo = null;
        if (null != source) {
            if (source.equals("IOS")) {
                adminUpushVo = redisUtil.get(KylinRedisConst.ADMIN_UPUSH_LIST_IOS);
            } else if (source.equals("Android")) {
                adminUpushVo = redisUtil.get(KylinRedisConst.ADMIN_UPUSH_LIST_ANDROID);
            }
        }
        if (null == adminUpushVo || page > 1) { // 不分页了 大于第一页返回空
            voPageInfo = PageInfo.of(new LinkedList<>());
        } else {
            LinkedList<AdminUpushVo> pushList = (LinkedList<AdminUpushVo>) adminUpushVo;
            Integer num = 0;
            for (AdminUpushVo info : pushList) {
                if (num == 0) {
                    redisUtil.set(KylinRedisConst.ADMIN_UPUSH_LIST_READ_UID.concat(uid), info.getUpushId());
                }
                num++;
                if (!info.getImg().isEmpty()) {
                    String img = imgUrl + info.getImg();
                    info.setImg(img);
                }
            }
            voPageInfo = PageInfo.of(pushList);
            voPageInfo.setTotal(pushList.size());
        }
        return voPageInfo;
    }

    public Integer unread(HttpServletRequest request) {
        String uid = CurrentUtil.getCurrentUid();
        Object obj = redisUtil.get(KylinRedisConst.ADMIN_UPUSH_LIST_READ_UID.concat(uid));

        String source = request.getHeader("source");
        Object adminUpushVo = null;
        if (null != source) {
            if (source.equals("IOS")) {
                adminUpushVo = redisUtil.get(KylinRedisConst.ADMIN_UPUSH_LIST_IOS);
            } else if (source.equals("Android")) {
                adminUpushVo = redisUtil.get(KylinRedisConst.ADMIN_UPUSH_LIST_ANDROID);
            }
        }

        if (null == adminUpushVo || null == source) {
            return 0;
        }

        LinkedList<AdminUpushVo> pushList = (LinkedList<AdminUpushVo>) adminUpushVo;

        if (null == obj) {
            return pushList.size();
        }

        Integer num = 0;
        String pushId = (String) obj;
        for (AdminUpushVo info : pushList) {
            if (info.getUpushId().equals(pushId)) {
                break;
            } else {
                num++;
            }
        }
        return num;
    }
}
