package com.liquidnet.service.kylin.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketTimesVo;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.kylin.entity.KylinOrderTicketRelations;
import com.liquidnet.service.kylin.entity.KylinOrderTicketStatus;
import com.liquidnet.service.kylin.entity.KylinOrderTickets;
import com.liquidnet.service.kylin.mapper.KylinOrderTicketRelationsMapper;
import com.liquidnet.service.kylin.mapper.KylinOrderTicketStatusMapper;
import com.liquidnet.service.kylin.mapper.KylinOrderTicketsMapper;
import com.liquidnet.service.kylin.utils.DataUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.web.bind.annotation.*;

import java.time.format.DateTimeFormatter;

@Api(tags = "WYF修复订单")
@RestController
@RequestMapping("/wyf/repaire")
public class WyfRepairOrderController {

    @Autowired
    private MongoTemplate mongoTemplate;

    @Autowired
    private DataUtils dataUtils;

    @Autowired
    private KylinOrderTicketsMapper kylinOrderTicketsMapper;
    @Autowired
    private KylinOrderTicketStatusMapper kylinOrderTicketStatusMapper;
    @Autowired
    private KylinOrderTicketRelationsMapper kylinOrderTicketRelationsMapper;

    @PutMapping("")
    @ApiOperation("")
    public ResponseDto<KylinOrderTicketVo> RepairOrder(@RequestParam(value = "orderTicketsId") String orderTicketsId,
                                            @RequestParam(value = "performanceId") String performanceId){
        // 1.
        KylinOrderTickets orderTickets = queryOrderTickets(orderTicketsId);
        KylinOrderTicketStatus orderTicketStatus = queryOrderTicketsStatus(orderTicketsId);
        KylinOrderTicketRelations orderTicketRelations = queryOrderTicketRelations(orderTicketsId);

        KylinPerformanceVo performanceData = dataUtils.getPerformanceVo(performanceId);

        KylinTicketTimesVo ticketTimesData = null;
        KylinTicketVo ticketData = null;
        for (int x = 0; x < performanceData.getTicketTimeList().size(); x++) {
            KylinTicketTimesVo timeItem = performanceData.getTicketTimeList().get(x);
            if (timeItem.getTimeId().equals(orderTicketRelations.getTimeId())) {
                ticketTimesData = timeItem;
                for (int y = 0; y < ticketTimesData.getTicketList().size(); y++) {
                    KylinTicketVo ticketItem = ticketTimesData.getTicketList().get(y);
                    if (ticketItem.getTicketsId().equals(orderTicketRelations.getTicketId())) {
                        ticketData = ticketItem;
                        break;
                    }
                }
                break;
            }
        }

        KylinOrderTicketVo orderTicketVo = KylinOrderTicketVo.getNew();
        orderTicketVo.setOrderTicket(orderTickets);
        orderTicketVo.setOrderTicketStatus(orderTicketStatus);
        orderTicketVo.setOrderTicketRelation(orderTicketRelations);
        orderTicketVo.setPerformanceImg(performanceData.getImgPoster());
        orderTicketVo.setTicketTitle(ticketData.getTitle());
        orderTicketVo.setUseStart(ticketData.getUseStart());
        orderTicketVo.setTimeStart(performanceData.getTimeStart());
        orderTicketVo.setOverdueAt(orderTickets.getCreatedAt().plusMinutes(performanceData.getPayCountdownMinute()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        orderTicketVo.setCreatedAt(orderTickets.getCreatedAt().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        orderTicketVo.setChangeDate(orderTickets.getCreatedAt());
        mongoTemplate.insert(orderTicketVo, KylinOrderTicketVo.class.getSimpleName());

        return ResponseDto.success(orderTicketVo);
    }

    private KylinOrderTicketRelations queryOrderTicketRelations(String orderTicketsId) {
        LambdaQueryWrapper<KylinOrderTicketRelations> eq = new QueryWrapper<KylinOrderTicketRelations>()
                .lambda()
                .eq(KylinOrderTicketRelations::getOrderId, orderTicketsId);
        return kylinOrderTicketRelationsMapper.selectOne(eq);
    }

    private KylinOrderTicketStatus queryOrderTicketsStatus(String orderTicketsId) {
        LambdaQueryWrapper<KylinOrderTicketStatus> eq = new QueryWrapper<KylinOrderTicketStatus>()
                .lambda()
                .eq(KylinOrderTicketStatus::getOrderId, orderTicketsId);
        return kylinOrderTicketStatusMapper.selectOne(eq);
    }

    private KylinOrderTickets queryOrderTickets(String orderTicketsId) {
        LambdaQueryWrapper<KylinOrderTickets> eq = new QueryWrapper<KylinOrderTickets>()
                .lambda()
                .eq(KylinOrderTickets::getOrderTicketsId, orderTicketsId);
        return kylinOrderTicketsMapper.selectOne(eq);
    }

}
