package com.liquidnet.client.admin.zhengzai.kylin.mapper;

import com.liquidnet.client.admin.zhengzai.kylin.domain.KylinOrderTickets;

import java.util.List;

/**
 * 订单Mapper接口
 * 
 * @author ruoyi
 * @date 2021-05-24
 */
public interface KylinOrderTicketsMapper 
{
    /**
     * 查询订单
     * 
     * @param mid 订单ID
     * @return 订单
     */
    public KylinOrderTickets selectKylinOrderTicketsById(Integer mid);

    /**
     * 查询订单列表
     * 
     * @param kylinOrderTickets 订单
     * @return 订单集合
     */
    public List<KylinOrderTickets> selectKylinOrderTicketsList(KylinOrderTickets kylinOrderTickets);

    /**
     * 新增订单
     * 
     * @param kylinOrderTickets 订单
     * @return 结果
     */
    public int insertKylinOrderTickets(KylinOrderTickets kylinOrderTickets);

    /**
     * 修改订单
     * 
     * @param kylinOrderTickets 订单
     * @return 结果
     */
    public int updateKylinOrderTickets(KylinOrderTickets kylinOrderTickets);

    /**
     * 删除订单
     * 
     * @param mid 订单ID
     * @return 结果
     */
    public int deleteKylinOrderTicketsById(Integer mid);

    /**
     * 批量删除订单
     * 
     * @param mids 需要删除的数据ID
     * @return 结果
     */
    public int deleteKylinOrderTicketsByIds(String[] mids);
}
