package com.liquidnet.service.account.wallet.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDateTime;

/**
 * WalletTransactionInfoVo.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/28
 */
@ApiModel(value = "WalletTransactionInfoVo", description = "Details of wallet transaction")
public class WalletTransactionInfoVo implements java.io.Serializable {
    private static final long serialVersionUID = 6166381986321328326L;
    @ApiModelProperty(position = 11, required = true, value = "*Wallet transaction number [64]")
    private String transNo;

    @ApiModelProperty(position = 12, value = "*Wallet available balance after transaction [20,6]")
    private BigDecimal balanceAvailable;
    @ApiModelProperty(position = 13, value = "*Wallet pending balance after transaction [20,6]")
    private BigDecimal balancePending;
    @ApiModelProperty(position = 14, value = "*Wallet frozen balance after transaction [20,6]")
    private BigDecimal balanceFrozen;

    @ApiModelProperty(position = 15, value = "Wallet transaction type [22]")
    private String transType;
    @ApiModelProperty(position = 16, value = "Wallet transaction status [5]")
    private Integer transStatus;
    @ApiModelProperty(position = 17, value = "Wallet transaction result description")
    private String reasons;
    @ApiModelProperty(position = 18, value = "Wallet transaction complete time")
    private LocalDateTime completeTime;

    @ApiModelProperty(position = 19, value = "Wallet account number [32]")
    private String walletNo;
    @ApiModelProperty(position = 20, value = "Transaction amount [20,6]")
    private BigDecimal amount;
    @ApiModelProperty(position = 21, value = "Transaction type [30]")
    private String tracingType;
    @ApiModelProperty(position = 22, value = "Transaction ID [64]")
    private String tracingNo;
    @ApiModelProperty(position = 23, value = "Transaction time")
    private LocalDateTime tracingTime;
    @ApiModelProperty(position = 24, value = "Transaction title [100]")
    private String tracingTitle;
    @ApiModelProperty(position = 25, value = "Transaction description [100]")
    private String tracingDesc;

    public String getTransNo() {
        return transNo;
    }

    public void setTransNo(String transNo) {
        this.transNo = transNo;
    }

    public BigDecimal getBalanceAvailable() {
        return balanceAvailable;
    }

    public void setBalanceAvailable(BigDecimal balanceAvailable) {
        this.balanceAvailable = balanceAvailable;
    }

    public BigDecimal getBalancePending() {
        return balancePending;
    }

    public void setBalancePending(BigDecimal balancePending) {
        this.balancePending = balancePending;
    }

    public BigDecimal getBalanceFrozen() {
        return balanceFrozen;
    }

    public void setBalanceFrozen(BigDecimal balanceFrozen) {
        this.balanceFrozen = balanceFrozen;
    }

    public String getTransType() {
        return transType;
    }

    public void setTransType(String transType) {
        this.transType = transType;
    }

    public Integer getTransStatus() {
        return transStatus;
    }

    public void setTransStatus(Integer transStatus) {
        this.transStatus = transStatus;
    }

    public LocalDateTime getCompleteTime() {
        return completeTime;
    }

    public void setCompleteTime(LocalDateTime completeTime) {
        this.completeTime = completeTime;
    }

    public String getReasons() {
        return reasons;
    }

    public void setReasons(String reasons) {
        this.reasons = reasons;
    }

    public String getWalletNo() {
        return walletNo;
    }

    public void setWalletNo(String walletNo) {
        this.walletNo = walletNo;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getTracingType() {
        return tracingType;
    }

    public void setTracingType(String tracingType) {
        this.tracingType = tracingType;
    }

    public String getTracingNo() {
        return tracingNo;
    }

    public void setTracingNo(String tracingNo) {
        this.tracingNo = tracingNo;
    }

    public LocalDateTime getTracingTime() {
        return tracingTime;
    }

    public void setTracingTime(LocalDateTime tracingTime) {
        this.tracingTime = tracingTime;
    }

    public String getTracingTitle() {
        return tracingTitle;
    }

    public void setTracingTitle(String tracingTitle) {
        this.tracingTitle = tracingTitle;
    }

    public String getTracingDesc() {
        return tracingDesc;
    }

    public void setTracingDesc(String tracingDesc) {
        this.tracingDesc = tracingDesc;
    }
}
