package com.liquidnet.service.goblin.param;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@Api
@Data
public class CouponCanUseParam implements Serializable, Cloneable {
    @ApiModelProperty(name = "param", value = "对象",required = true)
    @NotNull @NotBlank
    private List<CouponCanUse2Param> param;
    @ApiModelProperty(dataType = "String", name = "uid", value = "用户id",example = "10",required = false)
    private String uid;

    private static final CouponCanUseParam obj = new CouponCanUseParam();

    public static CouponCanUseParam getNew() {
        try {
            return (CouponCanUseParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new CouponCanUseParam();
    }

}
