package com.liquidnet.service.sweet.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.service.ISweetPerformanceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;

@Api(tags = "演出AR")
@RestController
@RequestMapping("/sweet-ar")
public class SweetPerformanceController {
    @Autowired
    private ISweetPerformanceService sweetPerformanceService;

    @PostMapping("add")
    @ApiOperation("添加")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "picOne", value = "图片1", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "picTwo", value = "图片2", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "arUrl", value = "AR地址", required = true),
            @ApiImplicitParam(type = "query", dataType = "LocalDateTime", name = "timeStart", value = "开始时间", required = true),
            @ApiImplicitParam(type = "query", dataType = "LocalDateTime", name = "timeEnd", value = "结束时间", required = true)
    })
    public ResponseDto<Boolean> add(@RequestParam() String picOne,
                                    @RequestParam() String picTwo,
                                    @RequestParam() String arUrl,
                                    @RequestParam() LocalDateTime timeStart,
                                    @RequestParam() LocalDateTime timeEnd) {
        return sweetPerformanceService.add(picOne, picTwo, arUrl, timeStart,timeEnd);
    }
}
