package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetPerformanceShow;
import com.liquidnet.service.sweet.mapper.SweetPerformanceMapper;
import com.liquidnet.service.sweet.service.ISweetPerformanceService;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

@Service
public class SweetPerformanceServiceImpl extends ServiceImpl<SweetPerformanceMapper, SweetPerformanceShow> implements ISweetPerformanceService {

    @Autowired
    private SweetPerformanceMapper sweetPerformanceMapper;
    @Autowired
    private RedisDataUtils redisDataUtils;


    @Override
    public ResponseDto<Boolean> add(String picOne, String picTwo, String arUrl, LocalDateTime timeStart, LocalDateTime timeEnd) {
        String offlineUrl=null;
        

        SweetPerformanceShow show = SweetPerformanceShow.getNew();
        String mid = IDGenerator.nextSnowId();
//        LocalDateTime time = LocalDateTime.now();
        show.setPerformanceId(mid);
        show.setPicOne(picOne);
        show.setPicTwo(picTwo);
        show.setArUrl(arUrl);
        show.setOfflineUrl(offlineUrl);
        show.setTimeStart(timeStart);
        show.setTimeEnd(timeEnd);
        sweetPerformanceMapper.insert(show);
        return ResponseDto.success();
    }
}
