package com.liquidnet.service.goblin.service.impl.inner;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinNftGoodsSkuListJobVo;
import com.liquidnet.service.goblin.service.GoblinCouponService;
import com.liquidnet.service.goblin.service.manage.IGoblinGoodsAnticipateMgService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinOrderUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.QueueUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

@Service
@Slf4j
public class GoblinNftJobServiceImpl {

    @Autowired
    private GoblinRedisUtils goblinRedisUtils;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    GoblinMongoUtils mongoUtils;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    private GoblinOrderUtils goblinOrderUtils;
    @Autowired
    GoblinCouponService goblinCouponService;
    @Autowired
    IGoblinGoodsAnticipateMgService goblinGoodsAnticipateMgService;

    public ResponseDto<Boolean> goodsList() {
        // mongo初始条件
        Query query = Query.query(
                Criteria.where("skuType").is(1).and("delFlg").is("0")
                        .and("status").is("3").and("shelvesStatus").is("3")
                        .and("skuAppear").is("0")
        );
        // 分页 排序:按照开售时间
        Pageable pageable = PageRequest.of(0, 100, Sort.by(Sort.Direction.DESC, "saleStartTime"));
        query.with(pageable);
        // 查询
        List<GoblinNftGoodsSkuListJobVo> skuInfoVos = mongoTemplate.find(query, GoblinNftGoodsSkuListJobVo.class, GoblinGoodsSkuInfoVo.class.getSimpleName());

        List<String> startSkuIdList = CollectionUtil.arrayListString();
        List<String> notStartSkuIdList = CollectionUtil.arrayListString();
        List<String> soldOutSkuIdList = CollectionUtil.arrayListString();

        LocalDateTime nowTime = LocalDateTime.now();
        for (GoblinNftGoodsSkuListJobVo info : skuInfoVos) {
            if (nowTime.compareTo(info.getSaleStartTime()) > 0) {// 已开卖
                List<String> skuIdList = CollectionUtil.arrayListString();
                if (info.getUnbox().equals("1")) {// 是盲盒，非盲盒少查一次spu
                    skuIdList = goblinRedisUtils.getGoodsInfoVo(info.getSpuId()).getSkuIdList();
                }
                HashMap<String, Integer> stockHashMap = goblinOrderUtils.getIsStock(info.getSkuId(), info.getUnbox(), info.getSoldoutStatus(), skuIdList);
                if (stockHashMap.get("isStock") == 1) {// 已开卖-未售罄
                    startSkuIdList.add(info.getSkuId());
                } else {// 已开卖-已售罄 时间正序
                    soldOutSkuIdList.add(info.getSkuId());
                }
            } else {// 未开卖 时间正序
                notStartSkuIdList.add(info.getSkuId());
            }
        }
        // 已开卖 时间倒序
        Collections.reverse(startSkuIdList);

        // 写入缓存
        goblinRedisUtils.setGoblinNftGoodsInfoListVo(startSkuIdList, "1");
        goblinRedisUtils.setGoblinNftGoodsInfoListVo(notStartSkuIdList, "2");
        goblinRedisUtils.setGoblinNftGoodsInfoListVo(soldOutSkuIdList, "3");

        return ResponseDto.success();
    }

}
