package com.liquidnet.service.adam.service.impl;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.dto.vo.*;
import com.liquidnet.service.adam.entity.AdamAddresses;
import com.liquidnet.service.adam.entity.AdamEnters;
import com.liquidnet.service.adam.service.IAdamRdmService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Service
public class AdamRdmServiceImpl implements IAdamRdmService {
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    MongoTemplate mongoTemplate;

    @Override
    public boolean setUidByMobile(String mobile, String uid) {
        return redisUtil.set(AdamRedisConst.IDENTITY_MOBILE.concat(mobile), uid);
    }

    @Override
    public String getUidByMobile(String mobile) {
        return (String) redisUtil.get(AdamRedisConst.IDENTITY_MOBILE.concat(mobile));
    }

    @Override
    public void delUidByMobile(String mobile) {
        redisUtil.del(AdamRedisConst.IDENTITY_MOBILE.concat(mobile));
    }

    @Override
    public boolean setUidByPlatformOpenId(String platform, String openId, String uid) {
        return redisUtil.set(AdamRedisConst.IDENTITY_THIRD_PARTY.concat(platform).concat(openId), uid);
    }

    @Override
    public String getUidByPlatformOpenId(String platform, String openId) {
        return (String) redisUtil.get(AdamRedisConst.IDENTITY_THIRD_PARTY.concat(platform).concat(openId));
    }

    @Override
    public void delUidByPlatformOpenId(String platform, String openId) {
        redisUtil.del(AdamRedisConst.IDENTITY_THIRD_PARTY.concat(platform).concat(openId));
    }

    @Override
    public boolean setUserInfoVoByUid(String uid, AdamUserInfoVo vo) {
        return redisUtil.set(AdamRedisConst.INFO_USER.concat(uid), vo);
    }

    @Override
    public AdamUserInfoVo getUserInfoVoByUid(String uid) {
        String rk = AdamRedisConst.INFO_USER.concat(uid);
        AdamUserInfoVo userInfoVo = (AdamUserInfoVo) redisUtil.get(rk);
        if (null == userInfoVo) {
            userInfoVo = mongoTemplate.findOne(Query.query(Criteria.where("uid").is(uid).and("state").is(1)),
                    AdamUserInfoVo.class, AdamUserInfoVo.class.getSimpleName());

            if (null != userInfoVo) redisUtil.set(rk, userInfoVo);
        }
        return userInfoVo;
    }

    @Override
    public void delUserInfoVoByUid(String uid) {
        redisUtil.del(AdamRedisConst.INFO_USER.concat(uid));
    }

    @Override
    public boolean setRealInfoVoByUid(String uid, AdamRealInfoVo vo) {
        return redisUtil.set(AdamRedisConst.INFO_REAL_NAME.concat(uid), vo);
    }

    @Override
    public AdamRealInfoVo getRealInfoVoByUid(String uid) {
        String rk = AdamRedisConst.INFO_REAL_NAME.concat(uid);
        AdamRealInfoVo realInfoVo = (AdamRealInfoVo) redisUtil.get(rk);
        if (null == realInfoVo) {
            realInfoVo = mongoTemplate.findOne(Query.query(Criteria.where("uid").is(uid).and("state").is(1)),
                    AdamRealInfoVo.class, AdamRealInfoVo.class.getSimpleName());

            if (null != realInfoVo) redisUtil.set(rk, realInfoVo);
        }
        return realInfoVo;
    }

    @Override
    public void delRealInfoVoByUid(String uid) {
        redisUtil.del(AdamRedisConst.INFO_REAL_NAME.concat(uid));
    }

    @Override
    public boolean setThirdPartVoListByUid(String uid, List<AdamThirdPartInfoVo> voList) {
        return redisUtil.set(AdamRedisConst.INFO_THIRD_PARTY.concat(uid), voList);
    }

    @Override
    public List<AdamThirdPartInfoVo> getThirdPartVoListByUid(String uid) {
        String rk = AdamRedisConst.INFO_THIRD_PARTY.concat(uid);
        List<AdamThirdPartInfoVo> thirdPartInfoVos = (List<AdamThirdPartInfoVo>) redisUtil.get(rk);
        if (CollectionUtils.isEmpty(thirdPartInfoVos)) {
            thirdPartInfoVos = mongoTemplate.find(Query.query(Criteria.where("uid").is(uid).and("state").is(1)),
                    AdamThirdPartInfoVo.class, AdamThirdPartInfoVo.class.getSimpleName());

            if (!CollectionUtils.isEmpty(thirdPartInfoVos)) redisUtil.set(rk, thirdPartInfoVos);
        }
        return thirdPartInfoVos;
    }

    @Override
    public AdamThirdPartInfoVo getThirdPartVoByUidPlatform(String uid, String platform) {
        List<AdamThirdPartInfoVo> list = this.getThirdPartVoListByUid(uid);
        if (!CollectionUtils.isEmpty(list))
            for (AdamThirdPartInfoVo r : list)
                if (platform.equals(r.getPlatform())) return r;
        return null;
    }

    @Override
    public void delThirdPartVoListByUid(String uid) {
        redisUtil.del(AdamRedisConst.INFO_THIRD_PARTY.concat(uid));
    }

    @Override
    public boolean setEntersByUid(String uid, List<AdamEnters> list) {
        return redisUtil.set(AdamRedisConst.INFO_ENTERS.concat(uid), list);
    }

    @Override
    public List<AdamEnters> getEntersByUid(String uid) {
        String rk = AdamRedisConst.INFO_ENTERS.concat(uid);
        List<AdamEnters> entersList = (List<AdamEnters>) redisUtil.get(rk);
        if (CollectionUtils.isEmpty(entersList)) {
            entersList = mongoTemplate.find(Query.query(Criteria.where("uid").is(uid).and("state").is(1)), AdamEnters.class, AdamEnters.class.getSimpleName());

            if (!CollectionUtils.isEmpty(entersList)) redisUtil.set(rk, entersList);
        }
        return entersList;
    }

    @Override
    public AdamEnters getEntersByUidEntersId(String uid, String entersId) {
        List<AdamEnters> entersList = this.getEntersByUid(uid);
        if (!CollectionUtils.isEmpty(entersList))
            for (AdamEnters r : entersList)
                if (entersId.equals(r.getEntersId())) return r;
        return null;
    }

    @Override
    public void delEntersByUid(String uid) {
        redisUtil.del(AdamRedisConst.INFO_ENTERS.concat(uid));
    }

    @Override
    public boolean setAddressesByUid(String uid, List<AdamAddresses> list) {
        return redisUtil.set(AdamRedisConst.INFO_ADDRESSES.concat(uid), list);
    }

    @Override
    public List<AdamAddresses> getAddressesByUid(String uid) {
        String rk = AdamRedisConst.INFO_ADDRESSES.concat(uid);
        List<AdamAddresses> list = (List<AdamAddresses>) redisUtil.get(rk);
        if (CollectionUtils.isEmpty(list)) {
            list = mongoTemplate.find(Query.query(Criteria.where("uid").is(uid).and("state").is(1)),
                    AdamAddresses.class, AdamAddresses.class.getSimpleName());

            if (!CollectionUtils.isEmpty(list)) redisUtil.set(rk, list);
        }
        return list;
    }

    @Override
    public AdamAddresses getAddressesByUidAddressesId(String uid, String addressesId) {
        List<AdamAddresses> list = this.getAddressesByUid(uid);
        if (!CollectionUtils.isEmpty(list))
            for (AdamAddresses r : list)
                if (addressesId.equals(r.getAddressesId())) return r;
        return null;
    }

    @Override
    public void delAddressesByUid(String uid) {
        redisUtil.del(AdamRedisConst.INFO_ADDRESSES.concat(uid));
    }

    @Override
    public boolean setUserMemberVoByUid(String uid, AdamUserMemberVo vo) {
        return redisUtil.set(AdamRedisConst.INFO_USER_MEMBER.concat(uid), vo);
    }

    @Override
    public AdamUserMemberVo getUserMemberVoByUid(String uid) {
        String rk = AdamRedisConst.INFO_USER_MEMBER.concat(uid);
        AdamUserMemberVo adamUserMemberVo = (AdamUserMemberVo) redisUtil.get(rk);
        if (null == adamUserMemberVo) {
            adamUserMemberVo = mongoTemplate.findOne(Query.query(Criteria.where("uid").is(uid)), AdamUserMemberVo.class, AdamUserMemberVo.class.getSimpleName());

            if (null != adamUserMemberVo) redisUtil.set(rk, adamUserMemberVo);
        }
        return adamUserMemberVo;
    }

    @Override
    public void delUserMemberVoByUid(String uid) {
        redisUtil.del(AdamRedisConst.INFO_USER_MEMBER.concat(uid));;
    }

    @Override
    public AdamMemberSimpleVo getMemberSimpleVo() {
        AdamMemberSimpleVo simpleVo = (AdamMemberSimpleVo) redisUtil.get(AdamRedisConst.INFO_MEMBER_SIMPLE);
        if (null == simpleVo) {
            List<AdamMemberSimpleVo> simpleVoList = mongoTemplate.findAll(AdamMemberSimpleVo.class, AdamMemberVo.class.getSimpleName());

            simpleVo = CollectionUtils.isEmpty(simpleVoList) ? null : simpleVoList.get(0);

            if (null != simpleVo) redisUtil.set(AdamRedisConst.INFO_MEMBER_SIMPLE, simpleVo);
        }
        return simpleVo;
    }
}
