package com.liquidnet.service.adam.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.liquidnet.common.exception.LiquidnetServiceException;
import com.liquidnet.commons.lang.util.*;
import com.liquidnet.service.adam.dto.AdamThirdPartParam;
import com.liquidnet.service.adam.dto.vo.AdamRealInfoVo;
import com.liquidnet.service.adam.dto.vo.AdamThirdPartInfoVo;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.adam.entity.AdamRealName;
import com.liquidnet.service.adam.service.AdamRdmService;
import com.liquidnet.service.adam.service.IAdamEntersService;
import com.liquidnet.service.adam.service.IAdamRealNameService;
import com.liquidnet.service.adam.service.IAdamUserService;
import com.liquidnet.service.adam.util.NknameUtil;
import com.liquidnet.service.adam.util.QueueUtils;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;

/**
 * <p>
 * 用户 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-10
 */
@Slf4j
@Service
public class AdamUserServiceImpl implements IAdamUserService {
    @Autowired
    Environment env;
//    @Autowired
//    MongoTemplate mongoTemplate;
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    IAdamEntersService adamEntersService;
    @Autowired
    IAdamRealNameService adamRealNameService;
    @Autowired
    AdamRdmService adamRdmService;



    private static final String PHP_API_REAL_NAME = "/IdCardCheckVerification";

    @Override
//    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public AdamUserInfoVo register(String mobile) {
        LocalDateTime now = LocalDateTime.now();
        AdamUserInfoVo userInfoVo = null;

//        if (RedisLockUtil.tryLock(LOCK_KEY_UREGISTER + mobile, 1, 5)) {
//            String uid = adamRdmService.getUidByMobile(mobile);
//            if (StringUtils.isEmpty(uid)) {
                userInfoVo = AdamUserInfoVo.getNew();
                userInfoVo.setUid(IDGenerator.nextSnowId() + "");
                userInfoVo.setMobile(mobile);
                userInfoVo.setNickname(NknameUtil.randomNkname());
                userInfoVo.setIsComplete(0);
                userInfoVo.setState(1);
                userInfoVo.setQrCode("lN".concat(userInfoVo.getUid()).concat(RandomStringUtils.randomAlphanumeric(5).toUpperCase()));
                userInfoVo.setCreateAt(now);

//                long s = System.currentTimeMillis();
//                mongoTemplate.insert(userInfoVo, AdamUserInfoVo.class.getSimpleName());
//                log.debug("#MDB耗时:{}ms", System.currentTimeMillis() - s);

                long s = System.currentTimeMillis();
                adamRdmService.setUidByMobile(mobile, userInfoVo.getUid());
                adamRdmService.setUserInfoVoByUid(userInfoVo.getUid(), userInfoVo);
                log.debug("#RDS耗时:{}ms", System.currentTimeMillis() - s);

                LinkedList<String> toMqSqls = CollectionUtil.linkedListString();
                LinkedList<Object[]> initUserObjs = CollectionUtil.linkedListObjectArr(),
                        initUserInfoObjs = CollectionUtil.linkedListObjectArr();

                s = System.currentTimeMillis();
                toMqSqls.add(SqlMapping.get("adam_user.add"));
                initUserObjs.add(new Object[]{userInfoVo.getUid(), userInfoVo.getMobile(), userInfoVo.getState(), 0, now});
                toMqSqls.add(SqlMapping.get("adam_user_info.add"));
                initUserInfoObjs.add(new Object[]{userInfoVo.getUid(), userInfoVo.getNickname(), null, userInfoVo.getQrCode()});
                log.debug("#SQL.GET耗时:{}ms", System.currentTimeMillis() - s);

                queueUtils.sendMsgByRedis(MQConst.AdamQueue.SQL_UREGISTER.getKey(),
                        SqlMapping.gets(toMqSqls, initUserObjs, initUserInfoObjs)
                );
                log.debug("#MQ耗时:{}ms", System.currentTimeMillis() - s);
//            } else {
//                userInfoVo = adamRdmService.getUserInfoVoByUid(uid);
//            }
//            RedisLockUtil.unlock(LOCK_KEY_UREGISTER + mobile);
//        }
        return userInfoVo;
    }

    @Override
//    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public AdamUserInfoVo register(AdamThirdPartParam param) {
        LocalDateTime now = LocalDateTime.now();
        AdamUserInfoVo userInfoVo = null;

//        if (RedisLockUtil.tryLock(LOCK_KEY_UREGISTER + param.getOpenId() + param.getPlatform(), 1, 5)) {
//            String uid = adamRdmService.getUidByPlatformOpenId(param.getPlatform(), param.getOpenId());
//            if (StringUtils.isEmpty(uid)) {
                long s = System.currentTimeMillis();
                String uid = adamRdmService.getUidByMobile(param.getMobile());
                log.debug("#RDS耗时:{}ms", System.currentTimeMillis() - s);
                LinkedList<String> toMqSqls = CollectionUtil.linkedListString();
                LinkedList<Object[]> initUserObjs = CollectionUtil.linkedListObjectArr(),
                        initUserInfoObjs = CollectionUtil.linkedListObjectArr(),
                        initThirdPartObjs = CollectionUtil.linkedListObjectArr();
                if (StringUtils.isEmpty(uid)) {// 手机号未注册
                    userInfoVo = AdamUserInfoVo.getNew();

                    userInfoVo.setUid(IDGenerator.nextSnowId() + "");
                    userInfoVo.setMobile(param.getMobile());
                    userInfoVo.setNickname(param.getNickname());
                    userInfoVo.setAvatar(param.getAvatar());
                    userInfoVo.setIsComplete(0);
                    userInfoVo.setState(1);
                    userInfoVo.setQrCode("lN".concat(userInfoVo.getUid()).concat(RandomStringUtils.randomAlphanumeric(5).toUpperCase()));
                    userInfoVo.setCreateAt(now);

//                    s = System.currentTimeMillis();
//                    mongoTemplate.insert(userInfoVo, AdamUserInfoVo.class.getSimpleName());
//                    log.debug("#MDB耗时:{}ms", System.currentTimeMillis() - s);

                    userInfoVo.setMobile(SensitizeUtil.custom(param.getMobile(), 3, 4));

                    adamRdmService.setUserInfoVoByUid(userInfoVo.getUid(), userInfoVo);

                    toMqSqls.add(SqlMapping.get("adam_user.add"));
                    initUserObjs.add(new Object[]{userInfoVo.getUid(), userInfoVo.getMobile(), userInfoVo.getState(), now});
                    toMqSqls.add(SqlMapping.get("adam_user_info.add"));
                    initUserInfoObjs.add(new Object[]{userInfoVo.getUid(), userInfoVo.getNickname(), userInfoVo.getAvatar(), userInfoVo.getQrCode()});
//                } else {
//                    s = System.currentTimeMillis();
//                    userInfoVo = adamRdmService.getUserInfoVoByUid(uid);
//                    log.debug("#RDS耗时:{}ms", System.currentTimeMillis() - s);
//                    toMqSqls.add(SqlMapping.get("adam_user.add"));
//                    toMqSqls.add(SqlMapping.get("adam_user_info.add"));
//                }

                AdamThirdPartInfoVo thirdPartInfoVo = AdamThirdPartInfoVo.getNew();
                BeanUtils.copyProperties(param, thirdPartInfoVo);
                thirdPartInfoVo.setCreatedAt(now);
                thirdPartInfoVo.setUid(userInfoVo.getUid());
                thirdPartInfoVo.setState(1);// 1-绑定

//                s = System.currentTimeMillis();
//                mongoTemplate.insert(thirdPartInfoVo, AdamThirdPartInfoVo.class.getSimpleName());
//                log.debug("#MDB耗时:{}ms", System.currentTimeMillis() - s);

                toMqSqls.add(SqlMapping.get("adam_third_party.add"));
                initThirdPartObjs.add(new Object[]{thirdPartInfoVo.getUid(), thirdPartInfoVo.getOpenId(), thirdPartInfoVo.getAvatar(), thirdPartInfoVo.getNickname(), thirdPartInfoVo.getPlatform(), thirdPartInfoVo.getState(), thirdPartInfoVo.getCreatedAt()});

                s = System.currentTimeMillis();
                adamRdmService.setUidByPlatformOpenId(param.getPlatform(), param.getOpenId(), uid);
                log.debug("#RDS耗时:{}ms", System.currentTimeMillis() - s);

                s = System.currentTimeMillis();
                queueUtils.sendMsgByRedis(MQConst.AdamQueue.SQL_UREGISTER.getKey(),
                        SqlMapping.gets(toMqSqls, initUserObjs, initUserInfoObjs, initThirdPartObjs)
                );
                log.debug("#MQ耗时:{}ms", System.currentTimeMillis() - s);
            } else {
                userInfoVo = adamRdmService.getUserInfoVoByUid(uid);
            }
//            RedisLockUtil.unlock(LOCK_KEY_UREGISTER + param.getOpenId() + param.getPlatform());
//        }
        return userInfoVo;
    }

    @Override
//    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void bindTpa(String uid, AdamThirdPartParam param) {
        LocalDateTime now = LocalDateTime.now();

        AdamThirdPartInfoVo thirdPartInfoVo = AdamThirdPartInfoVo.getNew();
        BeanUtils.copyProperties(param, thirdPartInfoVo);
        thirdPartInfoVo.setCreatedAt(now);
        thirdPartInfoVo.setUid(uid);
        thirdPartInfoVo.setState(1);// 1-绑定

//        long s = System.currentTimeMillis();
//        mongoTemplate.insert(thirdPartInfoVo, AdamThirdPartInfoVo.class.getSimpleName());
//        log.debug("#MDB耗时:{}ms", System.currentTimeMillis() - s);

        long s = System.currentTimeMillis();
        adamRdmService.setUidByPlatformOpenId(param.getPlatform(), param.getOpenId(), uid);
        log.debug("#RDS耗时:{}ms", System.currentTimeMillis() - s);

        s = System.currentTimeMillis();
        adamRdmService.delThirdPartVoListByUid(uid);
        log.debug("#RDS耗时:{}ms", System.currentTimeMillis() - s);

        s = System.currentTimeMillis();
        queueUtils.sendMsgByRedis(MQConst.AdamQueue.SQL_UCENTER.getKey(),
                SqlMapping.get(
                        "adam_third_party.add",
                        thirdPartInfoVo.getUid(), thirdPartInfoVo.getOpenId(), thirdPartInfoVo.getAvatar(), thirdPartInfoVo.getNickname(), thirdPartInfoVo.getPlatform(), thirdPartInfoVo.getState(), thirdPartInfoVo.getCreatedAt()
                )
        );
        log.debug("#MQ耗时:{}ms", System.currentTimeMillis() - s);
    }

    @Override
//    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void bindTpaForce(String bindUid, String unBindUid, AdamThirdPartParam param) {
        this.unBindTpaProcess(unBindUid, param.getPlatform());

        LocalDateTime now = LocalDateTime.now();

        AdamThirdPartInfoVo thirdPartInfoVo = AdamThirdPartInfoVo.getNew();
        BeanUtils.copyProperties(param, thirdPartInfoVo);
        thirdPartInfoVo.setCreatedAt(now);
        thirdPartInfoVo.setUid(bindUid);
        thirdPartInfoVo.setState(1);// 1-绑定

//        mongoTemplate.insert(thirdPartInfoVo, AdamThirdPartInfoVo.class.getSimpleName());

        adamRdmService.setUidByPlatformOpenId(param.getPlatform(), param.getOpenId(), bindUid);

        adamRdmService.delThirdPartVoListByUid(bindUid);

        queueUtils.sendMsgByRedis(MQConst.AdamQueue.SQL_UCENTER.getKey(),
                SqlMapping.get(
                        "adam_third_party.add",
                        thirdPartInfoVo.getUid(), thirdPartInfoVo.getOpenId(), thirdPartInfoVo.getAvatar(), thirdPartInfoVo.getNickname(), thirdPartInfoVo.getPlatform(), thirdPartInfoVo.getState(), thirdPartInfoVo.getCreatedAt()
                )
        );
    }

    /**
     * 解绑第三方账号操作
     *
     * @param uid
     * @param platform
     */
    private void unBindTpaProcess(String uid, String platform) {
        LocalDateTime now = LocalDateTime.now();

//        AdamThirdPartInfoVo unBindThirdPartInfoVo = AdamThirdPartInfoVo.getNew();
//        unBindThirdPartInfoVo.setUpdatedAt(now);
//        unBindThirdPartInfoVo.setState(2);// 2-解绑

//        long s = System.currentTimeMillis();
//        Document doc = mongoTemplate.getCollection(AdamThirdPartInfoVo.class.getSimpleName()).findOneAndUpdate(
//                Query.query(Criteria.where("uid").is(uid).and("platform").is(platform).and("state").is(1)).getQueryObject(),
//                new Document("$set", new Document("state", 2).append("updatedAt", now)),
//                new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
//        );
//        log.debug("#MDB耗时:{}ms", System.currentTimeMillis() - s);
//
//        s = System.currentTimeMillis();
//        if (null != doc) {
//            adamRdmService.delUidByPlatformOpenId(platform, doc.getString("openId"));
//        }
        long s = System.currentTimeMillis();
        AdamThirdPartInfoVo unBindTpaVo = adamRdmService.getThirdPartVoByUidPlatform(uid, platform);
        if (null != unBindTpaVo) {
            adamRdmService.delUidByPlatformOpenId(platform, unBindTpaVo.getOpenId());
        }
        adamRdmService.delThirdPartVoListByUid(uid);
        log.debug("#RDS耗时:{}ms", System.currentTimeMillis() - s);

        s = System.currentTimeMillis();
        queueUtils.sendMsgByRedis(MQConst.AdamQueue.SQL_UCENTER.getKey(),
                SqlMapping.get("adam_third_party.unbind", now, uid, platform)
        );
        log.debug("#MQ耗时:{}ms", System.currentTimeMillis() - s);
    }

    @Override
//    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void unBindTpa(String uid, String platform) {
        this.unBindTpaProcess(uid, platform);
    }

    @Override
//    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void close(String uid) {
        LocalDateTime now = LocalDateTime.now();
        LinkedList<String> toMqSqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> objsUser = CollectionUtil.linkedListObjectArr(),
                objsThirdPart = CollectionUtil.linkedListObjectArr(),
                objsAddresses = CollectionUtil.linkedListObjectArr();

        long s = System.currentTimeMillis();
        AdamUserInfoVo userInfoVo = adamRdmService.getUserInfoVoByUid(uid);

        adamRdmService.delUidByMobile(userInfoVo.getMobile());
        List<AdamThirdPartInfoVo> thirdPartInfoVos = adamRdmService.getThirdPartVoListByUid(uid);
        if (!CollectionUtils.isEmpty(thirdPartInfoVos)) {
            thirdPartInfoVos.forEach(r -> {
                adamRdmService.delUidByPlatformOpenId(r.getPlatform(), r.getOpenId());
            });
            adamRdmService.delThirdPartVoListByUid(uid);
        }
        adamRdmService.delUserInfoVoByUid(uid);
        adamRdmService.delUserMemberVoByUid(uid);
        adamRdmService.delAddressesVoByUid(uid);
        adamRdmService.delEntersVoByUid(uid);
        log.debug("##RDS耗时:{}ms", System.currentTimeMillis() - s);

//        DeleteResult deleteResult = mongoTemplate.remove(Query.query(Criteria.where("uid").is(uid)), AdamUserInfoVo.class.getSimpleName());
        toMqSqls.add(SqlMapping.get("adam_user.close"));
        objsUser.add(new Object[]{now, now, uid});

        /* ---------------------- 三方账号信息 */
        if (!CollectionUtils.isEmpty(thirdPartInfoVos)) {
//            s = System.currentTimeMillis();
//            mongoTemplate.remove(Query.query(Criteria.where("uid").is(uid)), AdamThirdPartInfoVo.class.getSimpleName());
//            log.debug("#MDB耗时:{}ms", System.currentTimeMillis() - s);
            toMqSqls.add(SqlMapping.get("adam_third_party.close"));
            objsThirdPart.add(new Object[]{now, uid});
        }

        /* ---------------------- 用户会员信息 */
//        s = System.currentTimeMillis();
//        deleteResult = mongoTemplate.remove(Query.query(Criteria.where("uid").is(uid)), AdamUserMemberVo.class.getSimpleName());
//        log.debug("#MDB耗时:{}ms", System.currentTimeMillis() - s);
//        if (deleteResult.getDeletedCount() > 0) {
            toMqSqls.add(SqlMapping.get("adam_user_member.close"));
            objsThirdPart.add(new Object[]{now, uid});
//        }

        /* ---------------------- 收货地址信息 */
//        s = System.currentTimeMillis();
//        deleteResult = mongoTemplate.remove(Query.query(Criteria.where("uid").is(uid)), AdamAddressesVo.class.getSimpleName());
//        log.debug("#MDB耗时:{}ms", System.currentTimeMillis() - s);
//        if (deleteResult.getDeletedCount() > 0) {
            toMqSqls.add(SqlMapping.get("adam_addresses.close"));
            objsAddresses.add(new Object[]{now, now, uid});
//        }

        /* ---------------------- 入场人信息 */
//        s = System.currentTimeMillis();
//        deleteResult = mongoTemplate.remove(Query.query(Criteria.where("uid").is(uid)).getQueryObject(), AdamEnters.class.getSimpleName());
//        log.debug("#MDB耗时:{}ms", System.currentTimeMillis() - s);
//        if (deleteResult.getDeletedCount() > 0) {
            toMqSqls.add(SqlMapping.get("adam_enters.close"));
            objsAddresses.add(new Object[]{now, now, uid});
//        }

        s = System.currentTimeMillis();
        queueUtils.sendMsgByRedis(
                MQConst.AdamQueue.SQL_UCENTER.getKey(),
                SqlMapping.gets(toMqSqls, objsUser)
        );
        log.debug("#MQ耗时:{}ms", System.currentTimeMillis() - s);
    }

    @Override
//    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public AdamRealInfoVo identity(String uid, String name, String idCard) {
        AdamRealInfoVo vo = null;
//        if (RedisLockUtil.tryLock(AdamRedisConst.LOCK_KEY_UIDENTITY + uid, 1, 3)) {
//            vo = adamRdmService.getRealInfoVoByUid(uid);
//            if (null == vo) {
                if (!adamRdmService.isCertification(1, idCard, name)) {
//                    String respStr = null;
//                    try {
//                        LinkedMultiValueMap<String, String> paramsMap = new LinkedMultiValueMap<>();
//                        paramsMap.add("realName", name);
//                        paramsMap.add("cardNo", idCard);
//                        long s = System.currentTimeMillis();
//                        respStr = HttpUtil.postToPhpApi(env.getProperty("liquidnet.url-service.url") + PHP_API_REAL_NAME, paramsMap);
//                        log.debug("#PHP.API耗时:{}ms", System.currentTimeMillis() - s);
//                        log.debug("###PHP.API[{}].RESP:{}", PHP_API_REAL_NAME, respStr);
//                        Map respMap = JsonUtils.fromJson(respStr, Map.class);
//                        if (CollectionUtils.isEmpty(respMap) || !StringUtils.equalsIgnoreCase("OK", (String) respMap.get("message"))) {
//                            log.warn("PHP.API实名认证失败[uid:{},name:{},idCard:{},respStr:{}]", uid, name, idCard, respStr);
//                            ErrorMapping.ErrorMessage errorMessage = ErrorMapping.get("10102");
//                            throw new LiquidnetServiceException(errorMessage.getCode(), errorMessage.getMessage());
//                        }
//                    } catch (Exception e) {
//                        log.error("PHP.API实名认证异常[uid:{},name:{},idCard:{},respStr:{}]", uid, name, idCard, respStr, e);
//                        ErrorMapping.ErrorMessage errorMessage = ErrorMapping.get("10102");
//                        throw new LiquidnetServiceException(errorMessage.getCode(), errorMessage.getMessage());
//                    }
                    String respStr = IdentityUtils.aliThird(name, idCard);
                    JsonNode respJNode = JsonUtils.fromJson(respStr, JsonNode.class);
                    if (null == respJNode || !"0".equals(respJNode.get("error_code").asText())) {
                        log.info("###实名认证失败[{}]", respStr);
                        ErrorMapping.ErrorMessage errorMessage = ErrorMapping.get("10102");
                        throw new LiquidnetServiceException(errorMessage.getCode(), errorMessage.getMessage());
                    }
                    adamRdmService.setCertification(1, idCard, name);
                }

                AdamRealName realName = new AdamRealName();
                realName.setRealNameId(IDGenerator.nextSnowId() + "");
                realName.setUid(uid);
                realName.setType(1);
                realName.setName(name);
                realName.setIdCard(idCard);
                realName.setState(1);
                realName.setCreatedAt(LocalDateTime.now());
                adamRealNameService.add(realName);

                vo = AdamRealInfoVo.getNew();
                vo.setUid(uid);
                vo.setName(name);
                vo.setIdCard(idCard);
                vo.setType(realName.getType());
                vo.setState(1);

                long s = System.currentTimeMillis();
                adamRdmService.setRealInfoVoByUid(uid, vo);
                log.debug("#RDS耗时:{}ms", System.currentTimeMillis() - s);
//            }
//            RedisLockUtil.unlock(AdamRedisConst.LOCK_KEY_UIDENTITY + uid);
//        }
        return vo;
    }
}
