package com.liquidnet.service.adam.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.adam.dto.vo.*;
import com.liquidnet.service.adam.service.AdamRdmService;
import com.liquidnet.service.adam.service.IAdamUserMemberService;
import com.liquidnet.service.base.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;

@ApiSupport(order = 10030)
@Api(tags = "会员信息")
@Slf4j
@Validated
@RestController
@RequestMapping("member")
public class AdamMemberController {
    @Autowired
    AdamRdmService adamRdmService;
    @Autowired
    IAdamUserMemberService adamUserMemberService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "会员信息")
    @GetMapping("info")
    public ResponseDto<AdamMemberVo> info() {
        AdamMemberSimpleVo memberSimpleVo = adamRdmService.getMemberSimpleVo();
        AdamMemberVo memberVo = null;
        if (null != memberSimpleVo && null != (memberVo = adamRdmService.getMemberVoByMemberId(memberSimpleVo.getMemberId()))) {
//            memberVo.setBuySwitch(adamRdmService.getSwitch(AdamRedisConst.SWITCH_BUY_MEMBER));
            memberVo.calculateLimitMarker(adamRdmService.getMaxMemberLimitation());

            memberVo.setPriceVoList(adamRdmService.getMemberPriceVoByMemberId(memberVo.getMemberId()));

            String currentUid = CurrentUtil.getCurrentUid();
            if (!StringUtils.isEmpty(currentUid)) {
                AdamUserMemberVo userMemberVo = adamRdmService.getUserMemberVoByUid(currentUid);

                memberVo.setUserMemberVo(userMemberVo);

                if (null == userMemberVo || !userMemberVo.isActive()) {
                    memberVo.setRightsVoList(adamRdmService.getMemberRightsVoByMemberId(memberVo.getMemberId(), 0));
                } else if (userMemberVo.isActive()) {
                    memberVo.setRightsVoList(
                            userMemberVo.isOldMember() ? adamRdmService.getMemberRightsVoByMemberId(memberVo.getMemberId(), 1)
                            : adamRdmService.getMemberRightsVoByMemberId(memberVo.getMemberId(), 0)
                    );
                }
            } else {
                memberVo.setUserMemberVo(null);
                memberVo.setRightsVoList(adamRdmService.getMemberRightsVoByMemberId(memberVo.getMemberId(), 0));
            }
        }
        return ResponseDto.success(memberVo);
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "会员协议")
    @GetMapping("agreement")
    public ResponseDto<String> agreement() {
        return ResponseDto.success(adamRdmService.getMemberAgreement());
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "权益详情")
    @GetMapping("info/rights")
    public ResponseDto<AdamMemberRightsDetailVo> infoRights(@RequestParam String memberId, @RequestParam String mrightsId) {
        return ResponseDto.success(adamRdmService.getMemberRightsDetailVoByRightsId(memberId, mrightsId));
    }

    /* ------------------------------------------------------------｜@API:RSC */

    @ApiOperationSupport(order = 99)
    @ApiOperation(value = "@API:是否会员", notes = "根据UID判断用户是否会员，响应参数[`data`:true-是,false-否]")
    @GetMapping("check/depth")
    public ResponseDto<Boolean> isMember(@NotBlank(message = "用户ID不能为空") @RequestParam String uid) {
        AdamUserMemberVo userMemberInfo = adamRdmService.getUserMemberVoByUid(uid);
        return ResponseDto.success(null != userMemberInfo && userMemberInfo.isActive());
    }

    @ApiOperationSupport(order = 98)
    @ApiOperation(value = "@API:是否会员[新老]", notes = "AdamUserMemberVo")
    @GetMapping("check/depth/new")
    public ResponseDto<AdamUserMemberVo> isMemberNew(@NotBlank(message = "用户ID不能为空") @RequestParam String uid) {
        AdamUserMemberVo userMemberInfo = adamRdmService.getUserMemberVoByUid(uid);
        return ResponseDto.success(userMemberInfo);
    }
}
