package com.liquidnet.service.galaxy.service.impl;

import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.galaxy.dto.param.*;
import com.liquidnet.service.galaxy.router.strategy.GalaxyRouterStrategyContext;
import com.liquidnet.service.galaxy.service.IGalaxyTradeService;
import com.liquidnet.service.galaxy.utils.QueueUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyTradeServiceImpl
 * @Package com.liquidnet.service.galaxy.service.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/17 14:19
 */
@Slf4j
@Service("galaxyTradeServiceImpl")
public class GalaxyTradeServiceImpl implements IGalaxyTradeService {
    @Autowired
    private QueueUtil queueUtil;

    @Autowired
    private GalaxyRouterStrategyContext galaxyRouterStrategyContext;

    @Override
    public ResponseDto<GalaxyNftBuyRespDto> nftBuy(GalaxyNftBuyReqDto reqDto) {
//        return galaxyRouterStrategyContext.getTradeStrategy(reqDto.getRouterType()).nftBuy(reqDto);
        return null;
    }

    @Override
    public ResponseDto<GalaxyNftPublishAndBuyRespDto> nftPublishAndBuy(GalaxyNftPublishAndBuyReqDto reqDto) {
        ResponseDto<GalaxyNftPublishAndBuyRespDto> responseDto = galaxyRouterStrategyContext.getTradeStrategy(reqDto.getRouterType()).nftPublishAndBuy(reqDto);
        if(!responseDto.isSuccess()){
            queueUtil.sendMsgByRedis(MQConst.GalaxyQueue.JSON_NFT_PUBLISH_AND_BUY.getKey(), JsonUtils.toJson(reqDto));
        }
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<GalaxyNftBuyResultQueryRespDto> nftBuyResultQuery(GalaxyNftBuyResultQueryReqDto reqDto) {
//        return galaxyRouterStrategyContext.getTradeStrategy(reqDto.getRouterType()).nftBuyResultQuery(reqDto);
        return null;
    }

    @Override
    public ResponseDto<GalaxyNftBuyPayResultQueryRespDto> nftBuyPayResultQuery(GalaxyNftBuyPayResultQueryReqDto reqDto) {
//        return galaxyRouterStrategyContext.getTradeStrategy(reqDto.getRouterType()).nftBuyPayResultQuery(reqDto);
        return null;
    }

    @Override
    public ResponseDto<GalaxyNftPublishAndBuyResultQueryRespDto> nftPublishAndBuyResultQuery(GalaxyNftPublishAndBuyResultQueryReqDto reqDto) {
        return galaxyRouterStrategyContext.getTradeStrategy(reqDto.getRouterType()).nftPublishAndBuyResultQuery(reqDto);
    }

    @Override
    public ResponseDto<GalaxyNftPublishAndBuyRouterBatchQueryRespDto> nftPublishAndBuyResultBatchQuery(GalaxyNftPublishAndBuyRouterBatchQueryReqDto reqDto) {
//        return galaxyRouterStrategyContext.getTradeStrategy(reqDto.getRouterType()).nftPublishAndBuyResultBatchQuery(reqDto);
        return null;
    }

    @Override
    public ResponseDto<GalaxyNftTransferRespDto> nftTransfer(GalaxyNftTransferReqDto reqDto) {
        return galaxyRouterStrategyContext.getTradeStrategy(reqDto.getRouterType()).nftTransfer(reqDto);
    }

    @Override
    public ResponseDto<GalaxyNftTransferQueryRespDto> nftTransferQuery(GalaxyNftTransferQueryReqDto reqDto) {
        return galaxyRouterStrategyContext.getTradeStrategy(reqDto.getRouterType()).nftTransferQuery(reqDto);
    }
}
