package com.liquidnet.service.kylin.service.partner;

import com.baomidou.mybatisplus.extension.service.IService;
import com.liquidnet.service.kylin.dto.param.CreateTicketTimesParam;
import com.liquidnet.service.kylin.dto.vo.partner.TicketTimesPartnerVo;
import com.liquidnet.service.kylin.entity.KylinTicketTimes;

import java.util.List;

/**
 * <p>
 * 场次 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-06
 */
public interface IKylinTicketTimesPartnerService extends IService<KylinTicketTimes> {


    /**
     * 创建场次汇总
     * @param createTicketTimesParam
     * @return
     */
    TicketTimesPartnerVo createTimesSummary(CreateTicketTimesParam createTicketTimesParam);

    /**
     * 未通过审核创建场次
     * @param createTicketTimesParam
     * @return
     */
    TicketTimesPartnerVo createTimes(CreateTicketTimesParam createTicketTimesParam);

    /**
     * 通过审核后创建场次
     * @param createTicketTimesParam
     * @return
     */
    TicketTimesPartnerVo addNewTimes(CreateTicketTimesParam createTicketTimesParam);

    /**
     * 删除 场次(只有未审核通过可删除)
     * @param ticketTimesId
     * @return
     */
    Boolean deleteTimes(String ticketTimesId);

    TicketTimesPartnerVo changeTimes(CreateTicketTimesParam createTicketTimesParam);

    List<TicketTimesPartnerVo> getTimesMongoList(String performancesId);

    TicketTimesPartnerVo getTimesMongo(String timesId);
}
