package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BannersDisplayLocation;
import com.liquidnet.client.admin.common.enums.BannersTargetType;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.KylinBannersServiceImpl;
import com.liquidnet.service.kylin.dao.BannerDetailsListDao;
import com.liquidnet.service.kylin.dto.param.BannersParam;
import com.liquidnet.service.kylin.dto.param.BannersSearchParam;
import com.liquidnet.service.kylin.dto.vo.KylinBannersVo;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 轮播图 后端管理控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-01
 */

@Controller
@RequestMapping("/kylin/banners")
public class KylinBannersAdminController extends BaseController {

    private String prefix = "zhengzai/kylin/banners";

    @Value("${liquidnet.url-banner.url6}")
    private String url6;
    @Value("${liquidnet.url-banner.url7}")
    private String url7;
    @Value("${liquidnet.url-banner.url14}")
    private String url14;

    @Value("${liquidnet.client.admin.platformUrl}")
    private String platformUrl;

    @Autowired
    private KylinBannersServiceImpl kylinBannersServiceImpl;

    @GetMapping("/create")
    public String create(ModelMap mmap) {
        List<Object> bannersTargetType = BannersTargetType.getResultType();
        List<Object> bannersDisplayLocation = BannersDisplayLocation.getResultType();
        mmap.put("BannersTargetType", bannersTargetType);
        mmap.put("BannersDisplayLocation", bannersDisplayLocation);

        mmap.put("platformUrl", platformUrl);

        mmap.put("url6", url6);
        mmap.put("url7", url7);
        mmap.put("url14", url14);

        return prefix + "/create";
    }

    @Log(title = "Banner列表", businessType = BusinessType.INSERT)
    @RequiresPermissions("kylin:banners:create")
    @PostMapping("create")
    @ResponseBody
    public AjaxResult createSave(BannersParam bannersParam) {
        Boolean res = kylinBannersServiceImpl.create(bannersParam);
        if (res) {
            return success();
        } else {
            return error("添加banner失败");
        }
    }

    @GetMapping("/update/{bannersId}")
    public String update(@PathVariable("bannersId") String bannersId, ModelMap mmap) {
        KylinBannersVo result = null;
        result = kylinBannersServiceImpl.detail(bannersId);

        List<Object> bannersTargetType = BannersTargetType.getResultType();
        List<Object> bannersDisplayLocation = BannersDisplayLocation.getResultType();

        mmap.put("KylinBannersVo", result);

        mmap.put("BannersTargetType", bannersTargetType);
        mmap.put("BannersDisplayLocation", bannersDisplayLocation);

        mmap.put("platformUrl", platformUrl);

        mmap.put("url6", url6);
        mmap.put("url7", url7);
        mmap.put("url14", url14);

        return prefix + "/update";
    }

    @Log(title = "Banner列表", businessType = BusinessType.UPDATE)
    @RequiresPermissions("kylin:banners:update")
    @PostMapping("update")
    @ResponseBody
    public AjaxResult updateSave(BannersParam bannersParam) {
        boolean res = kylinBannersServiceImpl.update(bannersParam);
        if (res) {
            return success();
        } else {
            return error("修改banner失败");
        }
    }

    /*@RequiresPermissions("kylin:banners:detail")
    @GetMapping("/details/{bannersId}")
    public String detail(@PathVariable("bannersId") String bannersId, ModelMap mmap) {
        KylinBannersVo result = null;
        result = kylinBannersServiceImpl.detail(bannersId);
        mmap.put("KylinBannersVo", result);
        return prefix + "/details";
    }*/

    @RequiresPermissions("kylin:banners:view")
    @GetMapping()
    public String banners() {
        return prefix + "/banners";
    }

    @Log(title = "Banner列表", businessType = BusinessType.LIST)
    @RequiresPermissions("kylin:banners:list")
    @PostMapping("list")
    @ResponseBody
    public TableDataInfo bannerList(BannersSearchParam bannersSearchParam) {
        PageInfo<BannerDetailsListDao> result = kylinBannersServiceImpl.bannerList(bannersSearchParam);
        return getDataTable(result.getList());
    }

    @Log(title = "Banner列表", businessType = BusinessType.DELETE)
    @RequiresPermissions("kylin:banners:delete")
    @PostMapping("delete")
    @ResponseBody
    public AjaxResult delete(BannersParam bannersParam) {
        List<String> bannersId = bannersParam.getIds();
        boolean result = kylinBannersServiceImpl.delete(bannersId);
        if (result) {
            return success("删除成功");
        } else {
            return error("删除失败");
        }
    }

}
