package com.liquidnet.service.util;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.goblin.constant.SmileRedisConst;
import com.liquidnet.service.goblin.dto.vo.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

@Slf4j
@Component
public class SmileRedisUtils {
    @Autowired
    RedisUtil redisUtil;

    private int randomMax = 10;

    public void del(String... keys) {
        redisUtil.del(keys);
    }
    /* ---------------------------------------- smileUser ---------------------------------------- */
    public SmileUserVO getSmileUserVo(String userId){
       return (SmileUserVO) redisUtil.get(SmileRedisConst.SMILE_USER.concat(userId));
    }
    public void setSmileUserVo(String userId,SmileUserVO smileUserVORedis){
        redisUtil.set(SmileRedisConst.SMILE_USER.concat(userId),smileUserVORedis);
    }
    /* ---------------------------------------- school ---------------------------------------- */
    public List<SmileSchoolVo> getSchool(){
        return (List<SmileSchoolVo>) redisUtil.get(SmileRedisConst.SMILE_SCHOOL);
    }
    /* ---------------------------------------- 认证 ---------------------------------------- */
    public String getValidate(String realName,String cardNo){
        return (String) redisUtil.get(SmileRedisConst.SMILE_USER_VALIDATE.concat(realName+cardNo));
    }
    public void setValidate(String realName,String cardNo,String type){
        redisUtil.set(SmileRedisConst.SMILE_USER_VALIDATE.concat(realName+cardNo),type);
    }
    /* ---------------------------------------- 销售数据 ---------------------------------------- */
    public SmileSellDataVO getSellDataVo(String userId, String performanceId){
       return  (SmileSellDataVO) redisUtil.get(SmileRedisConst.SELL_DATA.concat(userId).concat(performanceId));
    }

    /* ---------------------------------------- 佣金明细数据 ---------------------------------------- */
    public CommissionVO getCommissionVO(String userId){
        return (CommissionVO) redisUtil.get(SmileRedisConst.SELL_DATA_COMMISSION.concat(userId));
    }
    /* ---------------------------------------- 演出列表数据 ---------------------------------------- */
    public String getSmileShow(){
        return (String) redisUtil.get(SmileRedisConst.SMILE_SHOW);
    }
    /* ---------------------------------------- 代理数据 ---------------------------------------- */
    public SmileAgentVo getSmileAgentVo(String performanceId,String ticketId){
        return (SmileAgentVo) redisUtil.get(SmileRedisConst.SMILE_AGENT.concat(performanceId).concat(":").concat(ticketId));
    }

}
