package com.liquidnet.service.order.utils;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.commons.lang.util.*;
import com.liquidnet.service.adam.dto.vo.AdamRscPolymer01Vo;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.candy.param.BackCouponParam;
import com.liquidnet.service.candy.vo.CandyCouponVo;
import com.liquidnet.service.candy.vo.CandyUseResultVo;
import com.liquidnet.service.goblin.constant.GoblinStatusConst;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.entity.GoblinBackOrder;
import com.liquidnet.service.goblin.entity.GoblinBackOrderLog;
import com.liquidnet.service.goblin.entity.GoblinOrderOperationLog;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

@Component
@Slf4j
public class GoblinOrderUtils {

    @Value("${liquidnet.service.adam.url}")
    private String adamUrl;
    @Value("${liquidnet.service.candy.url}")
    private String candyUrl;
    @Value("${liquidnet.service.stone.url}")
    private String stoneUrl;
    @Value("${liquidnet.service.order.url-pay.goblinRefundUrl}")
    private String synUrl;
    @Value("${liquidnet.service.dragon.urls.refundApply}")
    private String refundApply;

    @Autowired
    QueueUtils queueUtils;
    @Autowired
    GoblinRedisUtils redisUtils;
    @Autowired
    GoblinMongoUtils goblinMongoUtils;

    //判断 数量限购
    public String judgeOrderLimit(String uid, String skuId, int number, int limitCount) {
        int buyCount = redisUtils.getSkuCountByUid(uid, skuId);
        if (buyCount + number > limitCount) {
            return "已超出限购数量";
        } else {
            int a = redisUtils.incrSkuCountByUid(uid, skuId, number);
            return "";
        }
    }

    //判断指定人群购买
    public Boolean judgeOrderRose(Boolean isMember, String skuId, String mobile, int buyFactor) {
        Boolean result = false;
        switch (buyFactor) {
            case 0:
                result = true;
                break;
            case 1:
                result = isMember;
                break;
            case 2:
                result = redisUtils.getSkuCanBuyByUid(mobile, skuId);
                break;
        }
        return result;
    }

    /**
     * 使用优惠券
     *
     * @param uCouponId  券id
     * @param content    消费内容
     * @param totalPrice 订单总价
     * @return
     */
    public HashMap<String, Object> useCoupon(String uCouponId, String content, BigDecimal totalPrice, String spuId, String uid) {
        HashMap<String, Object> hashMap = CollectionUtil.mapStringObject();
        try {
            MultiValueMap<String, String> params = CollectionUtil.linkedMultiValueMapStringString();
            params.add("uCouponId", uCouponId);
            params.add("content", content);
            params.add("totalPrice", totalPrice.toString());
            params.add("goodId", spuId);
            params.add("performanceId", "null");
            params.add("timeId", "null");
            params.add("ticketId", "null");
            params.add("uid", uid);
            MultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
            header.add("Authorization", "Bearer " + CurrentUtil.getToken());
            header.add("Accept", "application/json;charset=UTF-8");
            log.debug("url=" + candyUrl + "/candy-coupon/use");
            String returnData = HttpUtil.post(candyUrl + "/candy-coupon/use", params, header);
            ResponseDto<CandyUseResultVo> innerReturnVo = JsonUtils.fromJson(returnData, new TypeReference<ResponseDto<CandyUseResultVo>>() {
            });
            CandyUseResultVo candyUseResultVo = innerReturnVo.getData();
            Integer type = candyUseResultVo.getCouType();
            BigDecimal value = candyUseResultVo.getValue();
            BigDecimal voucher = BigDecimal.ZERO;
            switch (type) {
                case -1:
                    voucher = BigDecimal.valueOf(-1);
                    break;
                case 1:
                    voucher = voucher.add(value);
                    break;
                case 2:
                    voucher = voucher.add(value);
                    break;
                case 3:
                    voucher = voucher.add(totalPrice);
                    break;
                case 4:
                    voucher = totalPrice.subtract(totalPrice.multiply(value));
                    break;
                default:
                    voucher = BigDecimal.ZERO;
                    break;
            }
            hashMap.put("type", type);
            hashMap.put("voucher", voucher.setScale(2, BigDecimal.ROUND_HALF_UP));
            return hashMap;
        } catch (Exception e) {
            log.error("用券ERROR:{}", e);
            return null;
        }
    }

    public void backCoupon(String uCouponId, String uid) {
        try {
            BackCouponParam param = BackCouponParam.getNew();
            param.setuCouponIds(uCouponId);
            param.setUid(uid);

            MultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
            header.add("Authorization", "Bearer " + CurrentUtil.getToken());
            header.add("Accept", "application/json;charset=UTF-8");
            ArrayList<BackCouponParam> params = new ArrayList();
            params.add(param);
            String jsonString = JSON.toJSONString(params);
            String returnData = HttpUtil.postRaw(candyUrl + "/candy-coupon/useBack", jsonString, header);
        } catch (Exception e) {
            log.error("回退券ERROR:{}", e);
        }
    }

    public void doTask(String uid, BigDecimal price) {
        try {
            MultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
            header.add("Accept", "application/json;charset=UTF-8");
            MultiValueMap<String, String> params = CollectionUtil.linkedMultiValueMapStringString();
            params.add("score", price.intValue() + "");
            params.add("content", "购买商品:");
            params.add("uid", uid);
            String resultData = HttpUtil.post(stoneUrl + "/user/logs/in2111", params, header);
        } catch (Exception e) {
            log.error("添加积分失败,e:{}", e);
            e.printStackTrace();
        }
    }

    public void desTask(String uid, BigDecimal price) {
        try {
            MultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
            header.add("Accept", "application/json;charset=UTF-8");
            MultiValueMap<String, String> params = CollectionUtil.linkedMultiValueMapStringString();
            params.add("score", price.intValue() + "");
            params.add("content", "购买商品:");
            params.add("uid", uid);
            String resultData = HttpUtil.post(stoneUrl + "/user/logs/de2111", params, header);
        } catch (Exception e) {
            log.error("添加积分失败,e:{}", e);
            e.printStackTrace();
        }
    }

    public GoblinUseResultVo useStoreCoupon(String ucouponId, String content, BigDecimal totalPrice, String spuId, String uid) {
        try {
            List<GoblinUserCouponVo> voList = redisUtils.getUserCouponVos(uid);
            GoblinUseResultVo returnVo = GoblinUseResultVo.getNew();
            returnVo.setValue(BigDecimal.ZERO);
            returnVo.setCouType("-1");
            for (GoblinUserCouponVo vo : voList) {
                if (vo.getUcouponId().equals(ucouponId)) {
                    //判断券状态 和 触发金额
                    if ((vo.getState().equals(1)) && vo.getTriggers().compareTo(totalPrice) <= 0) {
                        if (vo.getUseScope().equals("0")) {
                            if (vo.getType().equals("1")) {//代金券
                                returnVo.setValue(vo.getValFace());
                                returnVo.setCouType(vo.getType());
                            } else if (vo.getType().equals("2")) {//折扣
                                BigDecimal tempPrice = totalPrice.multiply(vo.getDiscount()).setScale(2, BigDecimal.ROUND_HALF_UP);
                                if (tempPrice.compareTo(vo.getDeduction()) > 0) {
                                    tempPrice = vo.getDeduction();
                                }
                                returnVo.setValue(tempPrice);
                                returnVo.setCouType(vo.getType());
                            } else if (vo.getType().equals("3") && vo.getTriggers().compareTo(totalPrice) <= 0) {//满减
                                returnVo.setValue(vo.getValMinus());
                                returnVo.setCouType(vo.getType());
                            }
                            vo.setState(5);
                            vo.setUsedFor(content);
                            goblinMongoUtils.changeCouponVos(vo.getUcouponId(), vo);
                            queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_COUPON.getKey(),
                                    SqlMapping.get("goblin_user_coupon.updateState", vo.getState(), vo.getUsedFor(), LocalDateTime.now(), vo.getUcouponId()));
                            break;
                        } else {
                            List<String> spuIds = redisUtils.getStoreCouponSpuIds(vo.getStoreCouponId());
                            if (spuId == null) {
                                continue;
                            }
                            //判断是否在可用商品内
                            List<String> spuList = Arrays.asList(spuId.split(","));
                            for (String item : spuIds) {
                                if (spuList.contains(item)) {
                                    if (vo.getType().equals("1")) {//代金券
                                        returnVo.setValue(vo.getValFace());
                                        returnVo.setCouType(vo.getType());
                                    } else if (vo.getType().equals("2")) {//折扣
                                        BigDecimal tempPrice = totalPrice.multiply(vo.getDiscount()).setScale(2, BigDecimal.ROUND_HALF_UP);
                                        if (tempPrice.compareTo(vo.getDeduction()) > 0) {
                                            tempPrice = vo.getDeduction();
                                        }
                                        returnVo.setValue(tempPrice);
                                        returnVo.setCouType(vo.getType());
                                    } else if (vo.getType().equals("3") && vo.getTriggers().compareTo(totalPrice) <= 0) {//满减
                                        returnVo.setValue(vo.getValMinus());
                                        returnVo.setCouType(vo.getType());
                                    }
                                    vo.setState(5);
                                    vo.setUsedFor(content);
                                    goblinMongoUtils.changeCouponVos(vo.getUcouponId(), vo);
                                    queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_COUPON.getKey(),
                                            SqlMapping.get("goblin_user_coupon.updateState", vo.getState(), vo.getUsedFor(), LocalDateTime.now(), vo.getUcouponId()));
                                }
                                break;
                            }
                        }
                    }
                    break;
                }
            }
            if (!returnVo.getCouType().equals("-1")) {
                redisUtils.setUserCouponVos(uid, voList);
            }
            return returnVo;
        } catch (Exception e) {
            log.error("店铺券错误:{}", e);
            return null;
        }
    }

    public Boolean backStoreCoupon(List<com.liquidnet.service.goblin.param.BackCouponParam> params) {
        try {
            for (com.liquidnet.service.goblin.param.BackCouponParam item : params) {
                List<GoblinUserCouponVo> voList = redisUtils.getUserCouponVos(item.getUid());
                for (GoblinUserCouponVo vo : voList) {
                    if (vo.getUcouponId().equals(item.getuCouponIds())) {
                        if (LocalDateTime.now().isBefore(vo.getDuedAt())) {
                            vo.setState(1);
                            vo.setUsedFor("");
                            redisUtils.setUserCouponVos(item.getUid(), voList);
                            goblinMongoUtils.changeCouponVos(vo.getUcouponId(), vo);
                            queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_COUPON.getKey(),
                                    SqlMapping.get("goblin_user_coupon.updateState", vo.getState(), vo.getUsedFor(), LocalDateTime.now(), vo.getUcouponId()));
                        }
                        break;
                    }
                }
            }
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Integer getMember(String uid) {
        return redisUtils.getMember(uid);
    }


    //超时支付自动退款
    public Boolean refundOrderSku(String orderId) {
        String uid = CurrentUtil.getCurrentUid();
        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.getNowTime();
        List<GoblinBackOrderSkuVo> orderSkuVoList = ObjectUtil.goblinBackOrderSkuVoArrayList();
        GoblinStoreOrderVo orderVo = redisUtils.getGoblinOrder(orderId);
        BigDecimal refundPrice = BigDecimal.ZERO;
        for (String orderSkuIdItem : orderVo.getOrderSkuVoIds()) {
            GoblinOrderSkuVo orderSkuVo = redisUtils.getGoblinOrderSkuVo(orderSkuIdItem);
            GoblinBackOrderSkuVo backOrderSkuVo = GoblinBackOrderSkuVo.getNew();
            backOrderSkuVo.setOrderSkuId(orderSkuIdItem);
            backOrderSkuVo.setSpuId(orderSkuVo.getSpuId());
            backOrderSkuVo.setSpuName(orderSkuVo.getSpuName());
            backOrderSkuVo.setSkuId(orderSkuVo.getSkuId());
            backOrderSkuVo.setSkuName(orderSkuVo.getSkuName());
            backOrderSkuVo.setRefundPrice(orderSkuVo.getSkuPriceActual());
            backOrderSkuVo.setSkuSpecs(orderSkuVo.getSkuSpecs());
            backOrderSkuVo.setCreatedAt(nowStr);
            backOrderSkuVo.setSkuPic(orderSkuVo.getSkuImage());
            orderSkuVoList.add(backOrderSkuVo);
            refundPrice = refundPrice.add(orderSkuVo.getSkuPriceActual().subtract(orderSkuVo.getPriceRefund()));
        }
        //记录退款单
        String refundCode = IDGenerator.storeRefundCode(orderVo.getMasterOrderCode());
        GoblinBackOrder goblinBackOrder = GoblinBackOrder.getNew();
        goblinBackOrder.setBackOrderId(IDGenerator.nextTimeId2());
        goblinBackOrder.setBackCode(refundCode);
        goblinBackOrder.setOrderId(orderVo.getOrderId());
        goblinBackOrder.setOrderCode(orderVo.getOrderCode());
        goblinBackOrder.setStoreId(orderVo.getStoreId());
        goblinBackOrder.setUserId(orderVo.getUserId());
//        goblinBackOrder.setSkuIdNums(orderSkuId);
        goblinBackOrder.setType(GoblinStatusConst.Type.BACK_TYPE_1.getValue());
        goblinBackOrder.setReason(GoblinStatusConst.Type.BACK_REASON_TYPE_8.getDesc());
        goblinBackOrder.setDescribes("超时支付自动退款");
        refundPrice = refundPrice.add(orderVo.getPriceExpress());
        goblinBackOrder.setRealBackPrice(refundPrice);
        goblinBackOrder.setStatus(GoblinStatusConst.Status.ORDER_BACK_STATUS_0.getValue());
        goblinBackOrder.setAuditAt(now);
        goblinBackOrder.setCreatedAt(now);
        GoblinBackOrderVo backOrderVo = GoblinBackOrderVo.getNew().copy(goblinBackOrder);
        backOrderVo.setCreatedAt(nowStr);
        backOrderVo.setBackOrderSkuVos(orderSkuVoList);
        //添加日志
        GoblinBackOrderLog backOrderLog = initBackLog(goblinBackOrder.getBackOrderId(), uid, now);
        backOrderLog.setStatus(GoblinStatusConst.Status.ORDER_LOG_STATUS_22.getValue());
        backOrderLog.setOperationType(GoblinStatusConst.Type.OPERATION_TYPE_2.getValue());
        backOrderLog.setMessage("商户发起[自动退款]：orderId=[" + orderId + "],refundPrice=[" + refundPrice + "],[refundCode=" + refundCode + "]");
        //调用退款
        String returnString = initRefund(orderVo, refundPrice, refundCode);
        HashMap hashMapResult = JsonUtils.fromJson(returnString, HashMap.class);
        Boolean success = (Boolean) hashMapResult.get("success");
        String message = (String) hashMapResult.get("message");
        if (!success) {
            if (!(backOrderVo.getStatus() == GoblinStatusConst.Status.ORDER_BACK_STATUS_8.getValue() || backOrderVo.getStatus() == GoblinStatusConst.Status.ORDER_BACK_STATUS_2.getValue())) {
                backOrderVo.setStatus(GoblinStatusConst.Status.ORDER_BACK_STATUS_10.getValue());
                backOrderVo.setErrorReason(backOrderVo.getErrorReason() + ",失败原因：" + message);
                log.error("REFUND DATA = " + returnString);
            }
        }
        //redis
        redisUtils.setBackOrderVo(backOrderVo.getBackOrderId(), backOrderVo);
        redisUtils.addBackOrderByOrderId(orderVo.getOrderId(), backOrderVo.getBackOrderId());
        //mongo
        goblinMongoUtils.insertGoblinBackOrderVo(backOrderVo);
        //添加退款
        queueUtils.sendMsgByRedis(
                MQConst.GoblinQueue.GOBLIN_STORE_ORDER_OPERA.getKey(),
                SqlMapping.get("goblin_order.store.backOrder",
                        goblinBackOrder.getBackOrderId(), goblinBackOrder.getBackCode(), goblinBackOrder.getOrderId(),
                        goblinBackOrder.getOrderCode(), goblinBackOrder.getStoreId(), goblinBackOrder.getUserId(),
                        goblinBackOrder.getSkuIdNums(), goblinBackOrder.getType(), goblinBackOrder.getReason(),
                        goblinBackOrder.getDescribes(), goblinBackOrder.getRealBackPrice(), goblinBackOrder.getStatus(),
                        goblinBackOrder.getCreatedAt(), goblinBackOrder.getAuditAt(), goblinBackOrder.getErrorReason()
                )
        );
        //添加日志
        queueUtils.sendMsgByRedis(
                MQConst.GoblinQueue.GOBLIN_STORE_ORDER_OPERA.getKey(),
                SqlMapping.get("goblin_order.store.refundLog",
                        backOrderLog.getBackOrderLogId(), backOrderLog.getBackOrderId(), backOrderLog.getOperationType(),
                        backOrderLog.getMessage(), backOrderLog.getOperationName(), backOrderLog.getStatus(), now
                )
        );
        if (success) {
            return true;
        } else {
            log.error("退款失败:" + message);
            return false;
        }
    }

    private GoblinBackOrderLog initBackLog(String orderId, String uid, LocalDateTime now) {
        GoblinBackOrderLog log = GoblinBackOrderLog.getNew();
        log.setBackOrderId(orderId);
        log.setOperationName(uid);
        log.setBackOrderLogId(IDGenerator.nextTimeId2());
        log.setCreatedAt(now);
        return log;
    }

    private String initRefund(GoblinStoreOrderVo orderVo, BigDecimal price, String refundCode) {
        MultiValueMap<String, String> params = CollectionUtil.linkedMultiValueMapStringString();
        params.add("code", orderVo.getPayCode());
        params.add("notifyUrl", synUrl);
        params.add("orderCode", orderVo.getMasterOrderCode());
        params.add("orderRefundCode", refundCode);
        params.add("paymentId", orderVo.getPaymentId());
        params.add("paymentType", orderVo.getPaymentType());
        params.add("price", String.valueOf(price));
        BigDecimal totalPrice = BigDecimal.ZERO;
        totalPrice = totalPrice.add(price);
        params.add("priceTotal", String.valueOf(totalPrice));
        params.add("reason", "超时支付");
        MultiValueMap<String, String> headers = CollectionUtil.linkedMultiValueMapStringString();
        headers.add("Accept", "application/json;charset=UTF-8");
        String returnString = HttpUtil.post(refundApply, params, headers);
        log.debug("REFUND DATA = " + returnString);
        return returnString;
    }

    //订单异常处理
    public ResponseDto<GoblinPayInnerResultVo> orderException(List<String> skuAndPreListAndNumber, List<String> platformCodeList, List<String> storeCodeList, String uid, String message) {
        long time3 = System.currentTimeMillis();
        //回顾限购 回滚库存
        for (String item : skuAndPreListAndNumber) {
            String[] array = item.split(",");
            String skuId = array[0];
            String pre = array[1];
            int number = Integer.parseInt(array[2]);
            redisUtils.incrSkuStock(pre, skuId, number);
            if (noZhengzaiOrder(uid)) {
                redisUtils.decrSkuCountByUid(uid, skuId, number);
            }
        }
        //回退平台券
        for (String platformCode : platformCodeList) {
            backCoupon(platformCode, uid);
        }
        //回退店铺券
        List<com.liquidnet.service.goblin.param.BackCouponParam> params = ObjectUtil.getBackCouponParam();
        for (String storeCode : storeCodeList) {
            com.liquidnet.service.goblin.param.BackCouponParam backCouponParam = com.liquidnet.service.goblin.param.BackCouponParam.getNew();
            backCouponParam.setuCouponIds(storeCode);
            backCouponParam.setUid(uid);
            params.add(backCouponParam);
        }
        if (params.size() > 0) {
            backStoreCoupon(params);
        }
        log.info("回滚逻辑 " + (System.currentTimeMillis() - time3) + "ms");
        if (message == null && !message.equals("")) {
            return ResponseDto.failure(ErrorMapping.get("20018"));//乱七八糟异常
        } else {
            return ResponseDto.failure(message);//乱七八糟异常
        }
    }

    public boolean noZhengzaiOrder(String uid) {
        return !uid.equals("zhengzai");
    }
}
