package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 
 * </p>
 *
 * @author jobob
 * @since 2022-03-11
 */
@ApiModel(value = "SellDataOneVO", description = "销量数据")
@Data
public class SmileSellDataVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "活动名字")
    private  String activeName;
    @ApiModelProperty(value = "id(用户+活动id)")
    private  String sellDataId;
    @ApiModelProperty(value = "销售具体情况")
    List<SellDataOneVO> sellDataOneVO;
    @ApiModelProperty(value = "销售总金额")
    private BigDecimal sellAmount;
    @ApiModelProperty(value = "销售总数量")
    private BigDecimal sellNumber;
    @ApiModelProperty(value = "销售总佣金")
    private BigDecimal totalCommission;

    @ApiModelProperty(value = "更新时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime updateTime;

    private int deltag;

    private static final SmileSellDataVO obj = new SmileSellDataVO();

    public static SmileSellDataVO getNew() {
        try {
            return (SmileSellDataVO) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SmileSellDataVO();
        }
    }

    public static void main(String[] args) {
         String s="?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,0,?,?,?,?";
        System.out.println(s.split(",").length);
        String s1="img,`name`,`uid`,birthday,sex,phone,province_id,province,city_id,city,area_id,area,address,wechat,`type`,org_id,id_card,school_name,school_major,`identity`,tag,agent,error_reason,introduce,specialty1,specialty2,specialty3,`state`,del_tag,created_date,updated_date,school_id";
        System.out.println(s1.split(",").length);
    }


}
