package com.liquidnet.service.adam.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.service.adam.dto.vo.AdamAddressesVo;
import com.liquidnet.service.adam.dto.vo.AdamEntersVo;
import com.liquidnet.service.adam.dto.vo.AdamRscPolymer01Vo;
import com.liquidnet.service.adam.dto.vo.AdamUserMemberVo;
import com.liquidnet.service.adam.service.AdamRdmService;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;
import java.util.List;

@ApiSupport(order = 10080)
@Api(tags = "@API:RSC")
@Slf4j
@Validated
@RestController
@RequestMapping("rsc")
public class AdamRscController {
    @Autowired
    AdamRdmService adamRdmService;

    @ApiOperationSupport(order = 10)
    @ApiOperation(value = "@API:入场人列表", notes = "查取用户指定入场人列表")
    @GetMapping("inquire/enters")
    public ResponseDto<List<AdamEntersVo>> querysForDepth(@NotBlank(message = "入场人ID不能为空（多个ID以,分隔）") @RequestParam String entersIds,
                                                          @NotBlank(message = "用户ID不能为空") @RequestParam String uid) {
        List<AdamEntersVo> vos = adamRdmService.getEntersVoByUidEntersIds(uid, entersIds.split(","));
        return CollectionUtils.isEmpty(vos) ? ResponseDto.failure(ErrorMapping.get("10105")) : ResponseDto.success(vos);
    }

    @ApiOperationSupport(order = 20)
    @ApiOperation(value = "@API:票务下单所需信息查询", notes = "包括是否会员、收货地址及入场人信息")
    @GetMapping("inquire/of_buy_ticket")
    public ResponseDto<AdamRscPolymer01Vo> queryForBuyTicket(@RequestParam(required = false) String addressId,
                                                             @RequestParam(required = false) String entersIds,
                                                             @NotBlank(message = "用户ID不能为空") @RequestParam String uid) {
        AdamRscPolymer01Vo vo = AdamRscPolymer01Vo.getNew();

        AdamUserMemberVo userMemberInfo = adamRdmService.getUserMemberVoByUid(uid);
        vo.setMembership((null != userMemberInfo && userMemberInfo.isActive()) ? 1 : 0);

        if (!StringUtils.isEmpty(addressId)) {
            AdamAddressesVo addressesVo = adamRdmService.getAddressesVoByUidAddressesId(uid, addressId);
            vo.setAddressesVo(addressesVo);
        }

        if (!StringUtils.isEmpty(entersIds)) {
            List<AdamEntersVo> entersVos = adamRdmService.getEntersVoByUidEntersIds(uid, entersIds.split(","));
            vo.setEntersVos(entersVos);
        }

        return ResponseDto.success(vo);
    }
}
