package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyQueryNftTradeListRespDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/8 16:27
 */
@ApiModel(value = "GalaxyQueryNftTradeListRespDto", description = "单个NFT交易信息查询")
@Data
public class GalaxyQueryNftTradeListRespDto implements Serializable,Cloneable {
    @ApiModelProperty(position = 1, required = true, value = "skuId")
    private String skuId;

    @ApiModelProperty(position = 1, required = true, value = "seriesId")
    private String seriesId;

    @ApiModelProperty(position = 1, required = true, value = "name")
    private String name;

    @ApiModelProperty(position = 1, required = true, value = "creatorAddr")
    private String creatorAddr;

    @ApiModelProperty(position = 2, required = true, value = "totalCount")
    private Long totalCount;

    @ApiModelProperty(position = 3, required = true, value = "seriesBeginFromZero")
    private Boolean seriesBeginFromZero;

    @ApiModelProperty(position = 3, required = true, value = "crtCount")
    private Long crtCount;

    @ApiModelProperty(position = 3, required = true, value = "coverUrl")
    private String coverUrl;

    @ApiModelProperty(position = 3, required = true, value = "desc")
    private String desc;

    @ApiModelProperty(position = 3, required = true, value = "createTimeStamp")
    private String createTimeStamp;


    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyQueryNftTradeListRespDto obj = new GalaxyQueryNftTradeListRespDto();

    public static GalaxyQueryNftTradeListRespDto getNew() {
        try {
            return (GalaxyQueryNftTradeListRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyQueryNftTradeListRespDto();
        }
    }
}