package com.liquidnet.service.bank.currencycloud.service.impl;

import com.currencycloud.client.CurrencyCloudClient;
import com.currencycloud.client.exception.ApiException;
import com.currencycloud.client.model.Beneficiary;
import com.currencycloud.client.model.ErrorMessage;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.bank.currencycloud.entity.BankCcBeneficiary;
import com.liquidnet.service.bank.currencycloud.mapper.BankCcBeneficiaryMapper;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.List;
import java.util.Objects;

@Slf4j
@SpringBootTest
@RunWith(SpringRunner.class)
public class BankCcBeneficiariesServiceImplTest {

    @Autowired
    private BankCcBeneficiaryMapper bankCcBeneficiariesMapper;

    @Autowired
    private CurrencyCloudClient currencyCloudClient;

    @Test
    public void createBeneficiary() {

        Beneficiary beneficiaryResult = null;

        try {
            beneficiaryResult = currencyCloudClient.createBeneficiary(initDemo());
            Beneficiary target = JsonUtils.fromJson(JsonUtils.toJson(beneficiaryResult), Beneficiary.class);
        } catch (ApiException e) {
            log.error(Objects.toString(e));
            List<ErrorMessage> errors = e.getErrors();
            String errorCode = e.getErrorCode();
        }

        BankCcBeneficiary bankCcBeneficiaries = new BankCcBeneficiary();
        BeanUtils.copyProperties(beneficiaryResult, bankCcBeneficiaries);
        bankCcBeneficiariesMapper.insert(bankCcBeneficiaries);
        System.out.println(JsonUtils.toJson(bankCcBeneficiaries));
    }

    @Test
    public void deleteBeneficiary() {

        BankCcBeneficiary bankCcBeneficiaries = bankCcBeneficiariesMapper.selectById("4d72c702-33a2-4c8d-bd16-67def6888495");
        bankCcBeneficiariesMapper.deleteById(bankCcBeneficiaries);
    }

    private Beneficiary initDemo() {
        Beneficiary beneficiary = Beneficiary.create();
        beneficiary.setName("test");
        beneficiary.setBankAccountHolderName("Lyu");
        beneficiary.setBankCountry("GB");
        beneficiary.setCurrency("GBP");
        beneficiary.setAccountNumber("32847346");
        beneficiary.setRoutingCodeType1("sort_code");
        beneficiary.setRoutingCodeValue1("101193");
        beneficiary.setDefaultBeneficiary(true);
        beneficiary.setBeneficiaryEntityType("company");
        beneficiary.setBeneficiaryCompanyName("test");
        beneficiary.setCreatorContactId("154ef998-54bb-4e83-ad65-c859c1a234f7");
        return beneficiary;
    }
}
