package com.liquidnet.client.admin.zhengzai.smile.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileVSParam;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileVolunteersService;
import com.liquidnet.service.goblin.dto.vo.SmileVolunteersDetailsVo;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.smile.entity.*;
import com.liquidnet.service.smile.mapper.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class SmileVolunteersServiceImpl extends ServiceImpl<SmileVolunteersMapper, SmileVolunteers> implements ISmileVolunteersService {

    @Autowired
    SmileVolunteersMapper volunteersMapper;
    @Autowired
    SmileVolunteersProjectMapper volunteersProjectMapper;
    @Autowired
    SmileVolunteersTeamMapper volunteersTeamMapper;
    @Autowired
    SmileVolunteersTeamRelationMapper volunteersTeamRelationMapper;



    @Override
    public TableDataInfo list(SmileVSParam param) {
        try {
            TableDataInfo rspData = new TableDataInfo();
            PageHelper.startPage(param.getPageNum(), param.getPageSize());
            LambdaQueryWrapper<SmileVolunteers> wrappers = Wrappers.lambdaQuery(SmileVolunteers.class);
            if (param.getTitle() != null && !param.getTitle().equals("")) {
                List<String> projectIdArray = volunteersProjectMapper.selectList(Wrappers.lambdaQuery(SmileVolunteersProject.class).like(SmileVolunteersProject::getTitle, param.getTitle())).stream().map(SmileVolunteersProject::getProjectId).collect(Collectors.toList());
                wrappers.in(SmileVolunteers::getProjectId, projectIdArray);
            }
            if (param.getName() != null && !param.getName().equals("")) {
                wrappers.eq(SmileVolunteers::getName, param.getName());
            }
            if (param.getPhone() != null && !param.getPhone().equals("")) {
                wrappers.eq(SmileVolunteers::getPhone, param.getPhone());
            }
            if (param.getStatus() != null && !param.getStatus().equals(-1)) {
                wrappers.eq(SmileVolunteers::getStatus, param.getStatus());
            }
            List<SmileVolunteers> data = volunteersMapper.selectList(wrappers);
            rspData.setCode(0);
            rspData.setRows(data);
            rspData.setTotal(data.size());
            return rspData;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public AjaxResult audit(String projectId, String uid, String teamId, Integer status) {
        try {
            LambdaQueryWrapper<SmileVolunteers> wrappers = Wrappers.lambdaQuery(SmileVolunteers.class).eq(SmileVolunteers::getProjectId, projectId).eq(SmileVolunteers::getUid, uid);
            SmileVolunteers bean = volunteersMapper.selectOne(wrappers);
            if (bean != null && !bean.getStatus().equals(0)) {
                return AjaxResult.warn("已审核");
            }
            //审核
            SmileVolunteers smileVolunteers = SmileVolunteers.getNew();
            smileVolunteers.setStatus(status);
            volunteersMapper.update(smileVolunteers, wrappers);
            //添加组
            SmileVolunteersTeamRelation smileVolunteersTeamRelation = SmileVolunteersTeamRelation.getNew();
            smileVolunteersTeamRelation.setTeamId(teamId);
            smileVolunteersTeamRelation.setProjectId(projectId);
            smileVolunteersTeamRelation.setUid(uid);
            smileVolunteersTeamRelation.setCreatedAt(LocalDateTime.now());
            volunteersTeamRelationMapper.insert(smileVolunteersTeamRelation);
        } catch (Exception e) {
            e.printStackTrace();
            AjaxResult.warn("审核失败");
        }
        return AjaxResult.success("审核完成");
    }

    @Override
    public SmileVolunteersDetailsVo details(String projectId, String uid) {
        SmileVolunteers bean = volunteersMapper.selectOne(Wrappers.lambdaQuery(SmileVolunteers.class).eq(SmileVolunteers::getProjectId, projectId).eq(SmileVolunteers::getUid, uid));
        ArrayList<String> teamIdArray = CollectionUtil.arrayListString();
        if (bean == null) {
            return null;
        } else if (bean.getStatus().equals(0) || bean.getStatus().equals(2)) {//未审核通过显示用户的选择的组
            if (bean.getTeamId1() != null && !bean.getTeamId1().equals("")) {
                teamIdArray.add(bean.getTeamId1());
            }
            if (bean.getTeamId2() != null && !bean.getTeamId2().equals("")) {
                teamIdArray.add(bean.getTeamId2());
            }
            if (bean.getTeamId3() != null && !bean.getTeamId3().equals("")) {
                teamIdArray.add(bean.getTeamId3());
            }
        } else if (bean.getStatus().equals(1)) {//审核通过 显示分配的组
            List<String> teamIds = volunteersTeamRelationMapper.selectList(Wrappers.lambdaQuery(SmileVolunteersTeamRelation.class).eq(SmileVolunteersTeamRelation::getProjectId, projectId).eq(SmileVolunteersTeamRelation::getUid, uid))
                    .stream().map(SmileVolunteersTeamRelation::getTeamId).collect(Collectors.toList());
            teamIdArray.addAll(teamIds);
        } else {
            return null;
        }
        //获取 组内容
        List<SmileVolunteersTeam> volunteersTeamList = volunteersTeamMapper.selectList(Wrappers.lambdaQuery(SmileVolunteersTeam.class).in(SmileVolunteersTeam::getTeamId, teamIdArray));
        if (volunteersTeamList == null || volunteersTeamList.size() == 0) {
            return null;
        }
        //获取 活动名称
        SmileVolunteersProject volunteersProject = volunteersProjectMapper.selectOne(Wrappers.lambdaQuery(SmileVolunteersProject.class).in(SmileVolunteersProject::getProjectId, bean.getProjectId()));
        if (volunteersProject == null) {
            return null;
        }
        SmileVolunteersDetailsVo vo = SmileVolunteersDetailsVo.getNew().copy(bean, volunteersTeamList, volunteersProject.getTitle());
        return vo;
    }
}
