package com.liquidnet.service.util;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.goblin.constant.SmileRedisConst;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.smile.entity.SmileVolunteersTeam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Slf4j
@Component
public class SmileRedisUtils {
    @Autowired
    RedisUtil redisUtil;

    private int randomMax = 10;

    public void del(String... keys) {
        redisUtil.del(keys);
    }

    /* ---------------------------------------- smileUser ---------------------------------------- */
    public SmileUserVO getSmileUserVo(String userId) {
        return (SmileUserVO) redisUtil.get(SmileRedisConst.SMILE_USER.concat(userId));
    }

    public void setSmileUserVo(String userId, SmileUserVO smileUserVORedis) {
        redisUtil.set(SmileRedisConst.SMILE_USER.concat(userId), smileUserVORedis);
    }

    /* ---------------------------------------- school ---------------------------------------- */
    public List<SmileSchoolVo> getSchool() {
        return (List<SmileSchoolVo>) redisUtil.get(SmileRedisConst.SMILE_SCHOOL);
    }

    /* ---------------------------------------- 认证 ---------------------------------------- */
    public String getValidate(String realName, String cardNo) {
        return (String) redisUtil.get(SmileRedisConst.SMILE_USER_VALIDATE.concat(realName + cardNo));
    }

    public void setValidate(String realName, String cardNo, String type) {
        redisUtil.set(SmileRedisConst.SMILE_USER_VALIDATE.concat(realName + cardNo), type);
    }

    /* ---------------------------------------- 销售数据 ---------------------------------------- */
    public SmileSellDataVO getSellDataVo(String userId, String performanceId) {
        return (SmileSellDataVO) redisUtil.get(SmileRedisConst.SELL_DATA.concat(userId).concat(performanceId));
    }

    /* ---------------------------------------- 佣金明细数据 ---------------------------------------- */
    public CommissionVO getCommissionVO(String userId) {
        return (CommissionVO) redisUtil.get(SmileRedisConst.SELL_DATA_COMMISSION.concat(userId));
    }

    /* ---------------------------------------- 演出列表数据 ---------------------------------------- */
    public String getSmileShow() {
        return (String) redisUtil.get(SmileRedisConst.SMILE_SHOW);
    }

    /* ---------------------------------------- 代理数据 ---------------------------------------- */
    public SmileAgentVo getSmileAgentVo(String performanceId, String ticketId) {
        return (SmileAgentVo) redisUtil.get(SmileRedisConst.SMILE_AGENT.concat(performanceId).concat(":").concat(ticketId));
    }

    /**
     * 添加志愿者报名情况
     *
     * @param projectId 活动id
     * @param uid       用户id
     * @param teamIds   组id数组
     */
    public void setVolunteers(String projectId, String uid, ArrayList<String> teamIds) {
        String rdk = SmileRedisConst.VOLUNTEERS_DETAILS.concat(projectId).concat(":uid:").concat(uid);
        redisUtil.set(rdk, teamIds);
    }

    /**
     * 获取志愿者报名情况
     *
     * @param projectId 活动id
     * @param uid       用户id
     */
    public ArrayList<String> getVolunteers(String projectId, String uid) {
        String rdk = SmileRedisConst.VOLUNTEERS_DETAILS.concat(projectId).concat(":uid:").concat(uid);
        Object obj = redisUtil.get(rdk);
        if (obj == null) {
            return null;
        } else {
            return (ArrayList<String>) obj;
        }
    }

    //获取 志愿者活动详情
    public SmileProjectDetailsVo getProject(String projectId) {
        String rdk = SmileRedisConst.PROJECT_DETAILS.concat(projectId);
        Object obj = redisUtil.get(rdk);
        if (obj == null) {
            return null;
        } else {
            return (SmileProjectDetailsVo) obj;
        }
    }

    //获取 志愿者职责组详情
    public SmileVolunteersTeam getTeam(String teamId) {
        String rdk = SmileRedisConst.TEAM_DETAILS.concat(teamId);
        Object obj = redisUtil.get(rdk);
        if (obj == null) {
            return null;
        } else {
            return (SmileVolunteersTeam) obj;
        }
    }

    // 获取活动列表id
    public ArrayList<String> getProjectId() {
        String rdk = SmileRedisConst.PROJECT_ID_LIST;
        Object obj = redisUtil.get(rdk);
        if (obj == null) {
            return CollectionUtil.arrayListString();
        } else {
            return (ArrayList<String>) obj;
        }
    }
}
