package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * <p>
 * 商城订单表
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinNowOrderDetailsVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = " 订单id")
    private String orderId;
    @ApiModelProperty(value = " 订单号")
    private String orderCode;
    @ApiModelProperty(value = "支付单号")
    private String paymentId;
    @ApiModelProperty(value = " 商户单号")
    private String payCode;
    @ApiModelProperty(value = " 支付方式")
    private String payType;
    @ApiModelProperty(value = " 订单金额")
    private String priceActual;
    @ApiModelProperty(value = " 支付时间")
    private String payTime;

    private static final GoblinNowOrderDetailsVo obj = new GoblinNowOrderDetailsVo();

    public static GoblinNowOrderDetailsVo getNew() {
        try {
            return (GoblinNowOrderDetailsVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNowOrderDetailsVo();
        }
    }
}
