package com.liquidnet.service.goblin.enums;

/**
 * 支付状态枚举
 */

public enum PayStatus {

    NOT_PAID(0, "未支付"),
    PAID(1, "已支付"),
    PAYMENT_FAILED(2, "支付失败");

    private final int code;
    private final String description;

    PayStatus(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    // 根据 code 获取枚举实例
    public static PayStatus fromCode(int code) {
        for (PayStatus status : values()) {
            if (status.getCode() == code) {
                return status;
            }
        }
        throw new IllegalArgumentException("无效的支付状态码: " + code);
    }

    @Override
    public String toString() {
        return description;
    }

}
