package com.liquidnet.service.goblin.param;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Api
public class BackCouponParam implements Serializable, Cloneable {
    @ApiModelProperty(dataType = "String", name = "uCouponIds", value = "券唯一表示id(逗号隔开的字符串)",example = "1",required = true)
    @NotNull @NotBlank
    private String uCouponIds;
    @ApiModelProperty(dataType = "String", name = "uid", value = "用户id",example = "10",required = true)
    @NotNull @NotBlank
    private String uid;

    private static final BackCouponParam obj = new BackCouponParam();

    public static BackCouponParam getNew() {
        try {
            return (BackCouponParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new BackCouponParam();
    }

    public String getuCouponIds() {
        return uCouponIds;
    }

    public void setuCouponIds(String uCouponIds) {
        this.uCouponIds = uCouponIds;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }
}
