package com.liquidnet.service.kylin.dto.vo.partner;

import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinCheckUserVo;
import com.liquidnet.service.kylin.entity.KylinTicketTimeRelation;
import com.liquidnet.service.kylin.entity.KylinTicketTimes;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

//返回

@Data
public class KylinTicketTimesPartnerVo implements Serializable ,Cloneable{
    @ApiModelProperty(value = "主键id")
    private String ticketTimesId;

    @ApiModelProperty(value = "演出Id", example = "")
    private String performancesId;

    @ApiModelProperty(value = "场次名称")
    private String title;

    @ApiModelProperty(value = "场次适用开始时间")
    private String useStart;

    @ApiModelProperty(value = "场次适用结束时间")
    private String useEnd;

    @ApiModelProperty(value = "状态 -1新增 0不可见 1可见")
    private Integer status;

    @ApiModelProperty(value = "状态 1单日票 2通票")
    private Integer type;

    @ApiModelProperty(value = "是否开启缺票登记")
    private Integer isLackRegister;

    @ApiModelProperty(value = "是否开启实名认证限购 0关闭 1开启")
    private Integer realNameLimit;

    @ApiModelProperty(value = "创建时间")
    private String createdAt;

    @ApiModelProperty(value = "修改时间")
    private String updatedAt;

    private static final KylinTicketTimesPartnerVo obj = new KylinTicketTimesPartnerVo();
    public static KylinTicketTimesPartnerVo getNew() {
        try {
            return (KylinTicketTimesPartnerVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinTicketTimesPartnerVo();
        }
    }

    public KylinTicketTimesPartnerVo copy(KylinTicketTimes ticketTimes, KylinTicketTimeRelation ticketTimeRelation){
        this.setTicketTimesId(ticketTimeRelation.getTimesId());
        this.setPerformancesId(ticketTimeRelation.getTimesId());
        this.setTitle(ticketTimes.getTitle());
        this.setUseStart(DateUtil.Formatter.yyyyMMddHHmmss.format(ticketTimes.getUseStart()));
        this.setUseEnd(DateUtil.Formatter.yyyyMMddHHmmss.format(ticketTimes.getUseEnd()));
        this.setStatus(ticketTimes.getStatus());
        this.setType(ticketTimes.getType());
        this.setRealNameLimit(ticketTimes.getRealNameLimit());
        this.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(ticketTimes.getCreatedAt()));
        this.setUpdatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(ticketTimes.getUpdatedAt()));
        return this;
    }
}
