package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 场地数据
 * </p>
 *
 * @author liquidnet
 * @since 2021-04-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinFields implements Serializable  ,Cloneable{

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * fields_id
     */
    private String fieldsId;

    /**
     * 场地名称
     */
    private String name;

    /**
     * 英文名
     */
    private String nameEng;

    /**
     * 拼音
     */
    private String pinyin;

    /**
     * 封面图
     */
    private String coverImg;

    /**
     * 详细地址
     */
    private String address;

    /**
     * 经度
     */
    private String longitude;

    /**
     * 维度
     */
    private String latitude;

    /**
     * 联系电话
     */
    private String phone;

    /**
     * 描述
     */
    private String description;

    /**
     * 省id
     */
    private Integer provinceId;

    /**
     * 省名称
     */
    private String provinceName;

    /**
     * 城市id
     */
    private Integer cityId;

    /**
     * 城市名称
     */
    private String cityName;

    /**
     * 县id
     */
    private Integer districtId;

    /**
     * 县名称
     */
    private String districtName;

    /**
     * 拒绝理由
     */
    private String refuseMessage;

    /**
     * comment
     */
    private String comment;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;

    private static final KylinFields obj = new KylinFields();
    public static KylinFields getNew() {
        try {
            return (KylinFields) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinFields();
        }
    }

}
