package com.liquidnet.service.stone.vo;

import lombok.Data;

import java.io.Serializable;

/**
 * @author liquidnet
 * @since 2021-10-19
 */
@Data
public class StoneTaskVo implements Serializable,Cloneable {

    private static final long serialVersionUID = 1L;

    /**
     * 任务名称
     */
    private String taskName;

    /**
     * 任务Id
     */
    private Integer taskId;

    /**
     * 状态[1-每日任务|2-一次性任务]
     */
    private Integer taskType;

    /**
     * 连续完成次数 1
     */
    private Integer taskCount;

    /**
     * 完成日期 2021-12-01
     */
    private String taskTime;

    /**
     * 是否完成
     */
    private Integer isFinish;

    private static final StoneTaskVo obj = new StoneTaskVo();
    public static StoneTaskVo getNew() {
        try {
            return (StoneTaskVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new StoneTaskVo();
        }
    }
}
