package com.liquidnet.service.adam.dto.vo;

import com.liquidnet.commons.lang.util.SensitizeUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

@ApiModel(value = "AdamPosScanitVo", description = "POS机用户扫码信息")
@Data
public class AdamPosScanitVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 5633320792752494064L;
    @ApiModelProperty(position = 10, value = "会员标记[0-普通用户｜2-过期会员｜10-老会员｜11-新会员]")
    private String uid;
    @ApiModelProperty(position = 11, value = "昵称")
    private String nickname;
    @ApiModelProperty(position = 12, value = "手机号")
    private String mobile;
    @ApiModelProperty(position = 13, value = "会员标记[0-普通用户｜2-过期会员｜10-老会员｜11-新会员]")
    private Integer stageMarker;

    private static final AdamPosScanitVo obj = new AdamPosScanitVo();

    public static AdamPosScanitVo getNew() {
        try {
            return (AdamPosScanitVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamPosScanitVo();
        }
    }


    public AdamPosScanitVo desensitize() {
        this.setMobile(SensitizeUtil.custom(this.getMobile(), 3, 4));
        return this;
    }
}
