package com.liquidnet.service.kylin.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.kylin.constant.KylinTableStatusConst;
import com.liquidnet.service.kylin.dto.param.RefundApplyParam;
import com.liquidnet.service.kylin.dto.param.RefundCallbackParam;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketEntitiesVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.kylin.utils.DataUtils;
import com.liquidnet.service.kylin.utils.MongoVoUtils;
import com.mongodb.BasicDBObject;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.result.UpdateResult;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 订单退款表 服务实现类 处理数据 退款后状态的变化
 * </p>
 *
 * @author jiaangxiulong
 * @since 2021-05-26
 */
@Slf4j
@Service
public class KylinRefundsStatusServiceImpl {

    @Autowired
    private KylinOrderTicketsMapper kylinOrderTicketsMapper;

    @Autowired
    private KylinOrderTicketStatusMapper kylinOrderTicketStatusMapper;

    @Autowired
    private KylinOrderRefundsMapper kylinOrderRefundsMapper;

    @Autowired
    private KylinOrderTicketEntitiesMapper kylinOrderTicketEntitiesMapper;

    @Autowired
    private KylinOrderRefundsEntitiesMapper kylinOrderRefundsEntitiesMapper;

    @Autowired
    private KylinOrderTicketRelationsMapper kylinOrderTicketRelationsMapper;

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    private MongoConverter mongoConverter;

    @Autowired
    private DataUtils dataUtils;

    @Autowired
    private MongoVoUtils mongoVoUtils;

    public boolean orderTicketRefunded(RefundCallbackParam refundCallbackParam, KylinOrderRefunds refundInfo) {
        List<KylinOrderRefundEntities> refundEntities = kylinOrderRefundsEntitiesMapper.selectList(
                new QueryWrapper<KylinOrderRefundEntities>().eq("order_refunds_id", refundInfo.getOrderRefundsId())
        );
        List<String> orderTicketEntitiesIdsArr = refundEntities.stream().map(KylinOrderTicketEntities -> KylinOrderTicketEntities.getOrderTicketEntitiesId()).collect(Collectors.toList());
        String orderTicketsId = refundInfo.getOrderTicketsId();

        KylinOrderTicketRelations orderRelations = kylinOrderTicketRelationsMapper.selectOne(
                new QueryWrapper<KylinOrderTicketRelations>().eq("order_id", orderTicketsId)
        );

        // 更新数据
        // 订单状态表
        KylinOrderTickets orderInfo = kylinOrderTicketsMapper.selectOne(
                new QueryWrapper<KylinOrderTickets>().eq("order_tickets_id", orderTicketsId)
        );
        KylinOrderTicketStatus orderStatusTable = new KylinOrderTicketStatus();
        int newStatus = 0;
        if (refundCallbackParam.getRefund_price() + orderInfo.getPriceRefund().doubleValue() == orderInfo.getPriceActual().doubleValue()) {
            newStatus = KylinTableStatusConst.ORDER_STATUS4;
        } else {
            newStatus = KylinTableStatusConst.ORDER_STATUS6;
        }
        orderStatusTable.setStatus(newStatus);
        orderStatusTable.setUpdatedAt(LocalDateTime.now());
        kylinOrderTicketStatusMapper.update(
                orderStatusTable, new UpdateWrapper<KylinOrderTicketStatus>()
                        .eq("order_id", orderTicketsId)
        );

        // 入场人
        double priceActual = orderInfo.getPriceActual().doubleValue();
        double priceExpress = orderInfo.getPriceExpress().doubleValue();
        int allEntitiesCount = kylinOrderTicketEntitiesMapper.selectCount(// 总入场人数量 排出未付款的 用来计算单入场人的价格
                new QueryWrapper<KylinOrderTicketEntities>()
                        .eq("order_id", orderTicketsId)
                        .ne("is_payment", KylinTableStatusConst.ENTITIES_IS_PAYMENT0)
        );
        double onePrice = (priceActual - priceExpress) / allEntitiesCount;//单价
        int refundNumber = 0;
        for (String entitiesId : orderTicketEntitiesIdsArr) {
            KylinOrderTicketEntities EntitiesInfo = kylinOrderTicketEntitiesMapper.selectOne(//已退完成的
                    new QueryWrapper<KylinOrderTicketEntities>()
                            .eq("order_ticket_entities_id", entitiesId)
            );
            BigDecimal refundedPrice = EntitiesInfo.getRefundPrice();

            KylinOrderRefundEntities refundEntitiesInfo = kylinOrderRefundsEntitiesMapper.selectOne(
                    new QueryWrapper<KylinOrderRefundEntities>()
                            .eq("order_refunds_id", refundInfo.getOrderRefundsId())
                            .eq("order_ticket_entities_id", entitiesId)
            );

            KylinOrderTicketEntities entitiesTable = new KylinOrderTicketEntities();
            double priceNew = refundEntitiesInfo.getRefundPrice().doubleValue() + refundedPrice.doubleValue();
            int isPayment = 0;
            if (priceNew == onePrice) {
                isPayment = KylinTableStatusConst.ENTITIES_IS_PAYMENT3;
                refundNumber++;
            } else {
                isPayment = KylinTableStatusConst.ENTITIES_IS_PAYMENT4;
            }
            entitiesTable.setIsPayment(isPayment);
            entitiesTable.setUpdatedAt(LocalDateTime.now());
            entitiesTable.setRefundPrice(BigDecimal.valueOf(priceNew));
            Integer[] entitiesTableIsPayment = {KylinTableStatusConst.ENTITIES_IS_PAYMENT2, KylinTableStatusConst.ENTITIES_IS_PAYMENT4};
            kylinOrderTicketEntitiesMapper.update(entitiesTable, new UpdateWrapper<KylinOrderTicketEntities>()
                    .eq("order_ticket_entities_id", entitiesId)
                    .in("is_payment", entitiesTableIsPayment)
            );

            HashMap<String, Object> EntitiesVo = new HashMap<>();
            EntitiesVo.put("updatedAt", DateUtil.getNowTime());
            EntitiesVo.put("refundPrice", BigDecimal.valueOf(priceNew));
            EntitiesVo.put("isPayment", isPayment);
            BasicDBObject EntitiesVov = new BasicDBObject("$set", mongoConverter.convertToMongoType(EntitiesVo));
            UpdateResult updateResult = mongoTemplate.getCollection(KylinOrderTicketEntitiesVo.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("orderTicketEntitiesId").is(entitiesId)).getQueryObject(),
                    EntitiesVov
            );

            dataUtils.delOrderTicketEntitiesRedis(entitiesId);
        }

        // 订单表
        double price = orderInfo.getPriceRefund().doubleValue() + refundCallbackParam.getRefund_price();
        Integer num = orderInfo.getRefundNumber() + refundNumber;
        KylinOrderTickets update = new KylinOrderTickets();
        update.setRefundNumber(num);
        update.setPriceRefund(BigDecimal.valueOf(price));
        update.setUpdatedAt(LocalDateTime.now());
        kylinOrderTicketsMapper.update(
                update, new UpdateWrapper<KylinOrderTickets>()
                        .eq("order_tickets_id", orderTicketsId)
        );

        HashMap<String, Object> orderVo = new HashMap<>();
        orderVo.put("updatedAt", DateUtil.getNowTime());
        orderVo.put("priceRefund", BigDecimal.valueOf(price));
        orderVo.put("status", newStatus);
        orderVo.put("refundNumber", num);
        BasicDBObject orderVov = new BasicDBObject("$set", mongoConverter.convertToMongoType(orderVo));
        UpdateResult orderUpdateResult = mongoTemplate.getCollection(KylinOrderTicketVo.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("orderTicketsId").is(orderTicketsId)).getQueryObject(),
                orderVov
        );
        dataUtils.delOrderTicketRedis(orderTicketsId);
        mongoVoUtils.resetOrderListVo(orderInfo.getUserId(), 2, orderTicketsId,null);

        // 退款单完成
        KylinOrderRefunds kylinOrderRefunds = new KylinOrderRefunds();
        kylinOrderRefunds.setStatus(KylinTableStatusConst.ORDER_REFUND_STATUS_REFUNDED);
        kylinOrderRefunds.setRefundCode(refundCallbackParam.getRefund_code());
        kylinOrderRefunds.setRefundType(refundCallbackParam.getRefund_type());
        kylinOrderRefunds.setRefundId(refundCallbackParam.getRefund_id());
        kylinOrderRefunds.setRefundAt(refundCallbackParam.getRefund_at());
        kylinOrderRefunds.setUpdatedAt(LocalDateTime.now());
        kylinOrderRefundsMapper.update(
                kylinOrderRefunds,
                new UpdateWrapper<KylinOrderRefunds>().in("order_refunds_id", refundInfo.getOrderRefundsId())
        );

        if (refundInfo.getType() == KylinTableStatusConst.ORDER_REFUND_TYPE_APPLY) {
            // 退还库存
            for (String entitiesId : orderTicketEntitiesIdsArr) {
                dataUtils.changeSurplusGeneral(entitiesId, 1);
                KylinOrderTicketEntities entitiesInfo = kylinOrderTicketEntitiesMapper.selectOne(
                        new QueryWrapper<KylinOrderTicketEntities>().eq("order_ticket_entities_id", entitiesId)
                );
                dataUtils.changeBuyInfo(orderInfo.getUserId(), "", orderRelations.getPerformanceId(), entitiesInfo.getTicketId(), -1);
            }
        }

        return true;
    }

    public Boolean orderTicketRefunding(
            KylinOrderTickets orderInfo, String orderTicketsId,
            double RefundPriceExpress,
            List<String> ticketEntityIds, List<Double> entitiesPrice
    ) {
        // 基础数据
        String authId = "";
        String authName = "system_overtime_order_refund";
        String reason = "订单支付超时自动退款";
        // 本次退款票总金额
        double entitiesPriceSum = entitiesPrice.stream().mapToDouble(Double::doubleValue).sum();

        // TODO: 2021/5/27 事物 and 部分退款
        // 更新数据
        // 订单状态表 和 缓存
        KylinOrderTicketStatus orderStatusTable = new KylinOrderTicketStatus();
        orderStatusTable.setStatus(KylinTableStatusConst.ORDER_STATUS3);
        kylinOrderTicketStatusMapper.update(orderStatusTable, new UpdateWrapper<KylinOrderTicketStatus>()
                .eq("order_id", orderTicketsId));

        KylinOrderTicketVo kylinOrderTicketVo = new KylinOrderTicketVo();
        kylinOrderTicketVo.setStatus(KylinTableStatusConst.ORDER_STATUS3);
        BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(kylinOrderTicketVo)));
        Document orderDoc = mongoTemplate.getCollection(KylinOrderTicketVo.class.getSimpleName()).findOneAndUpdate(
                Query.query(Criteria.where("orderTicketsId").is(orderTicketsId)).getQueryObject(),
                orderObject,
                new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
        );
        dataUtils.delOrderTicketRedis(orderTicketsId);
        mongoVoUtils.resetOrderListVo(orderInfo.getUserId(), 2, orderTicketsId,null);


        // 订单入场人表 和 缓存
        for (String v : ticketEntityIds) {
            KylinOrderTicketEntities entitiesTable = new KylinOrderTicketEntities();
            entitiesTable.setIsPayment(KylinTableStatusConst.ENTITIES_IS_PAYMENT2);
            kylinOrderTicketEntitiesMapper.update(entitiesTable, new UpdateWrapper<KylinOrderTicketEntities>()
                    .eq("order_ticket_entities_id", v));

            KylinOrderTicketEntitiesVo kylinOrderTicketEntitiesVo = new KylinOrderTicketEntitiesVo();
            kylinOrderTicketEntitiesVo.setIsPayment(KylinTableStatusConst.ENTITIES_IS_PAYMENT2);
            BasicDBObject entitiesObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(kylinOrderTicketEntitiesVo)));
            Document entitiesDoc = mongoTemplate.getCollection(KylinOrderTicketEntitiesVo.class.getSimpleName()).findOneAndUpdate(
                    Query.query(Criteria.where("orderTicketEntitiesId").is(v)).getQueryObject(),
                    entitiesObject,
                    new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
            );

            dataUtils.delOrderTicketEntitiesRedis(v);
        }

        // 退款明细
        KylinOrderRefunds kylinOrderRefunds = new KylinOrderRefunds();
        String orderRefundsId = IDGenerator.nextSnowId();
        kylinOrderRefunds.setOrderRefundsId(orderRefundsId);
        kylinOrderRefunds.setOrderTicketsId(orderTicketsId);

        Integer refundCount = kylinOrderRefundsMapper.selectCount(
                new QueryWrapper<KylinOrderRefunds>()
                        .eq("order_tickets_id", orderTicketsId)
        );

        String orderRefundCode = orderInfo.getOrderCode();
        String codeNum = StringUtils.leftPad(String.valueOf(refundCount), 3, "0");
        kylinOrderRefunds.setOrderRefundCode(orderRefundCode.concat(codeNum));
        kylinOrderRefunds.setPrice(BigDecimal.valueOf(entitiesPriceSum));
        kylinOrderRefunds.setPriceExpress(BigDecimal.valueOf(RefundPriceExpress));
        kylinOrderRefunds.setStatus(KylinTableStatusConst.ORDER_REFUND_STATUS_APPLY);

        kylinOrderRefunds.setType(KylinTableStatusConst.ORDER_REFUND_TYPE_APPLY);
        kylinOrderRefunds.setApplicantId(authId);
        kylinOrderRefunds.setApplicantName(authName);
        kylinOrderRefunds.setApplicantAt(LocalDateTime.now());
        kylinOrderRefunds.setReason(reason);
        if (RefundPriceExpress > 0 && entitiesPriceSum > 0) {
            kylinOrderRefunds.setRefundCate(KylinTableStatusConst.ORDER_REFUND_CATE3);
        } else if (RefundPriceExpress > 0) {
            kylinOrderRefunds.setRefundCate(KylinTableStatusConst.ORDER_REFUND_CATE2);
        } else if (entitiesPriceSum > 0) {
            kylinOrderRefunds.setRefundCate(KylinTableStatusConst.ORDER_REFUND_CATE1);
        }
        kylinOrderRefunds.setCreatedAt(LocalDateTime.now());
        int rows = kylinOrderRefundsMapper.insert(kylinOrderRefunds);

        // 退款入场人表
        KylinOrderRefundEntities kylinOrderRefundEntities = new KylinOrderRefundEntities();
        for (int i = 0; i <= ticketEntityIds.size() - 1; i++) {
            String orderRefundsEntitiesId = IDGenerator.nextSnowId();
            kylinOrderRefundEntities.setOrderRefundsEntitiesId(orderRefundsEntitiesId);
            kylinOrderRefundEntities.setOrderRefundsId(orderRefundsId);
            kylinOrderRefundEntities.setRefundPrice(BigDecimal.valueOf(entitiesPrice.get(i)));
            kylinOrderRefundEntities.setOrderTicketEntitiesId(ticketEntityIds.get(i));
            kylinOrderRefundEntities.setCreatedAt(LocalDateTime.now());
            int rowsR = kylinOrderRefundsEntitiesMapper.insert(kylinOrderRefundEntities);
        }

        return true;
    }
}
