package com.liquidnet.service.sweet.controller;


import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetArtists;
import com.liquidnet.service.sweet.service.ISweetAnswerService;
import com.liquidnet.service.sweet.vo.SweetAnswerVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 答题表 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-08-12
 */
@Api(tags = "答案")
@RestController
@RequestMapping("/sweetAnswer")
public class SweetAnswerController {

    @Autowired
    private ISweetAnswerService sweetAnswerService;

    @GetMapping("info")
    @ApiOperation("获取答题记录详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "phone", value = "手机号", required = true)
    })
    public ResponseDto<SweetAnswerVo> getInfo(@RequestParam() String phone) {
        return sweetAnswerService.getInfo(phone);
    }

    @PostMapping("create")
    @ApiOperation("添加答题记录")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "phone", value = "手机号", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "answerJson", value = "答案json", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "imgUrl", value = "图片地址", required = true),
    })
    public ResponseDto<Boolean> add(@RequestParam() String phone, @RequestParam() String answerJson, @RequestParam() String imgUrl) {
        return sweetAnswerService.create(phone, answerJson, imgUrl);
    }

}
