package com.liquidnet.service.goblin.controller;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.dto.vo.GoblinShoppingCartVoo;
import com.liquidnet.service.goblin.service.impl.GoblinFrontServiceImpl;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zhangfuxin
 * @Description:前端接口
 * @date 2021/12/27 下午6:25
 */
@Api(tags = "前端需要登陆接口管理")
@RestController
@RequestMapping("/front")
public class GoblinFrontLoginController    {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;
    @Autowired
    private GoblinFrontServiceImpl goblinFrontService;

    @GetMapping("addShopCart")
    @ApiOperation("加入购物车")
    public ResponseDto addShopCart(@RequestParam(name = "spuId", required = true) String spuId,@RequestParam(name = "storeId", required = true) String storeId,@RequestParam(name = "skuId", required = true) String skuId,@RequestParam(name = "number", required = false) Integer number) {
        String userId=CurrentUtil.getCurrentUid();

        return ResponseDto.success( goblinFrontService.addShoopCart(spuId,storeId,skuId,number,userId));
    }
    @GetMapping("getShopCart")
    @ApiOperation("获得购物车")
    public ResponseDto<GoblinShoppingCartVoo> getShopCart() {
        String userId=CurrentUtil.getCurrentUid();
        redisUtil.del(GoblinRedisConst.FRONT_SHOPCART.concat(userId));
        return ResponseDto.success( );
    }








}
