package com.liquidnet.service.goblin.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.codec.vo.EncryptedReq;
import com.liquidnet.service.goblin.dto.manage.GoblinOrderParam;
import com.liquidnet.service.goblin.dto.vo.GoblinPayInnerResultVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreOrderVo;
import com.liquidnet.service.goblin.param.PayAgainParam;
import com.liquidnet.service.goblin.param.SyncOrderParam;
import com.liquidnet.service.goblin.service.IGoblinOrderAppService;
import com.liquidnet.service.goblin.service.IGoblinOrderService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

@Slf4j
@Api(tags = "订单相关-App")
@RestController
@RequestMapping("/order")
public class GoblinOrderAppController {

    @Autowired
    IGoblinOrderAppService goblinOrderAppService;

    @PostMapping("list")
    @ApiOperation("列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "page", value = "页数", example = "1"),
    })
    public ResponseDto<List<GoblinStoreOrderVo>> orderList(@RequestParam("page") @Valid int page) {
        return goblinOrderAppService.orderList(page);
    }

    @PostMapping("deltails")
    @ApiOperation("详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单id", example = "1"),
    })
    public ResponseDto<GoblinStoreOrderVo> orderDetails(@RequestParam("orderId") @Valid String orderId) {
        return goblinOrderAppService.orderDetails(orderId);
    }

}
