package com.liquidnet.service.goblin.service.manage;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinStorePurchaseCommonParam;
import com.liquidnet.service.goblin.dto.manage.GoblinStorePurchaseItemParam;
import com.liquidnet.service.goblin.dto.vo.GoblinMarketSpuListVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreMarketVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStorePurchaseSkuVo;

import java.util.List;

public interface IGoblinStorePurchasingService {

    /**
     * 活动列表
     *
     * @param page         页数
     * @param purchaseName 活动名称
     * @param status       状态
     * @param st           开始时间
     * @param et           结束时间
     * @param ct           创建时间
     * @return
     */
    ResponseDto<PageInfo<GoblinStoreMarketVo>> purchasingList(int page, String purchaseName, int status, String st, String et, String ct);

    /**
     * 活动状态操作
     *
     * @param marketId 活动秒杀id
     * @param status   状态
     * @return
     */
    ResponseDto<Boolean> purchasingStatus(String marketId, String storeId, int status);

    /**
     * 添加 限时秒杀活动
     *
     * @param purchaseName 秒杀活动名称
     * @param storeId      商铺id
     * @param st           开始时间
     * @param et           结束时间
     * @param isPre        是否预热
     * @param preTime      预热时间
     * @return
     */
    ResponseDto<Boolean> purchasingInsert(String purchaseName, String storeId, String st, String et, Integer isPre, String preTime);

    /**
     * @param marketId     活动id
     * @param purchaseName 秒杀活动名称
     * @param storeId      商铺id
     * @param st           开始时间
     * @param et           结束时间
     * @param isPre        是否预热
     * @param preTime      预热时间
     * @return
     */
    ResponseDto<Boolean> purchasingUpdate(String marketId, String purchaseName, String storeId, String st, String et, Integer isPre, String preTime);

    /**
     * 获取 限时秒杀 详情
     *
     * @param marketId 活动秒杀id
     * @return
     */
    ResponseDto<GoblinStoreMarketVo> purchasingDetails(String marketId, String storeId);

    /**
     * 获取活动内spu列表
     *
     * @param marketId 活动秒杀id
     * @param page     页数
     * @return
     */
    ResponseDto<List<GoblinMarketSpuListVo>> purchasingSpuList(String marketId, String storeId, int page);

    /**
     * 获取活动内sku列表
     *
     * @param marketId 活动秒杀id
     * @return
     */
    ResponseDto<List<GoblinStorePurchaseSkuVo>> purchasingSkuList(String marketId, String storeId, String spuId);

    /**
     * 添加活动相关sku
     *
     * @param params
     * @return
     */
    ResponseDto<Boolean> purchasingSkuInsert(GoblinStorePurchaseCommonParam params);

    /**
     * 编辑活动相关sku
     *
     * @param params
     * @return
     */
    ResponseDto<Boolean> purchasingSkuUpdate(GoblinStorePurchaseCommonParam params);

    /**
     * 删除活动内sku
     *
     * @param marketId 活动秒杀id
     * @param spuId    spuId
     * @return
     */
    ResponseDto<Boolean> purchasingSpuDel(String marketId, String storeId, String spuId);
}
