package com.liquidnet.service.goblin.controller;

import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinOrderParam;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.service.IGoblinAppZhengzaiService;
import com.liquidnet.service.goblin.service.IGoblinOrderAppService;
import com.liquidnet.service.goblin.service.IGoblinOrderService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

@Slf4j
@Api(tags = "正在下单相关")
@RestController
@RequestMapping("/zhengzai/app")
public class GoblinAppZhengzaiController {

    @Autowired
    IGoblinAppZhengzaiService goblinAppZhengzaiService;
    @Autowired
    IGoblinOrderService goblinOrderService;
    @Autowired
    IGoblinOrderAppService goblinOrderAppService;

    @GetMapping("market/list")
    @ApiOperation("正在下单-活动列表")
    public ResponseDto<List<GoblinSelfMarketingVo>> getZhengzaiMarketList() {
        return ResponseDto.success(goblinAppZhengzaiService.getZhengzaiMarketList());
    }

    @GetMapping("store/list")
    @ApiOperation("正在下单-参与活动的店铺")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
    })
    public ResponseDto<List<GoblinShowStoreInfoVo>> getStoreList(@RequestParam("marketId") @Valid String marketId) {
        return ResponseDto.success(goblinAppZhengzaiService.getStoreList(marketId));
    }

    @GetMapping("spu/list")
    @ApiOperation("正在下单-参与活动的spu")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "商铺id", example = "1"),
    })
    public ResponseDto<List<GoblinZhengzaiGoodVo>> getStoreList(@RequestParam("marketId") @Valid String marketId,
                                                                @RequestParam("storeId") @Valid String storeId) {
        return ResponseDto.success(goblinAppZhengzaiService.getSpuList(marketId, storeId));
    }

    @PostMapping("fc7bce6d6c2213b866f76493f92224b7")
    @ApiOperation("正在下单-下单")
    public ResponseDto<GoblinPayInnerResultVo> checkOrder(@RequestBody GoblinOrderParam param) {
        if (param.getUid() == null) {
            param.setUid("zhengzai");
        }
        return goblinOrderService.checkOrder(param, param.getUid());
    }

    @PostMapping("checkPayment")
    @ApiOperation("订单状态")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "masterCode", value = "masterCode", example = "1"),
    })
    public ResponseDto<Integer> checkOrderResultMasterCode(@RequestParam("masterCode") @Valid String masterCode) {
        return goblinOrderService.checkOrderResultMaterCode(masterCode);
    }

    @PostMapping("listByCode")
    @ApiOperation("列表[根据masterCode]")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderMasterCode", value = "主订单号"),
    })
    public ResponseDto<List<GoblinAppOrderListVo>> orderListByMaster(@RequestParam("orderMasterCode") @Valid String orderMasterCode) {
        return goblinOrderAppService.orderListByMaster(orderMasterCode);
    }

    @PostMapping("details")
    @ApiOperation("详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单id", example = "1"),
    })
    public ResponseDto<GoblinAppOrderDetailsVo> orderDetails(@RequestParam("orderId") @Valid String orderId) {
        String uid = CurrentUtil.getCurrentUid();
        return goblinOrderAppService.orderDetails(orderId, uid);
    }

    @PostMapping("checkPayment_dup1")
    @ApiOperation("正在下单-出货")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "masterCode", value = "masterCode", example = "1"),
    })
    public ResponseDto<List<GoblinZhengzaiPushVo>> orderPush(@RequestParam("masterCode") @Valid String masterCode) {
        return goblinAppZhengzaiService.orderPush(masterCode);
    }

    @PostMapping("checkPayment_dup2")
    @ApiOperation("正在下单-绑定订单号")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "masterCode", value = "masterCode", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "uid", value = "uid", example = "1"),
    })
    public ResponseDto<Boolean> orderBind(@RequestParam("masterCode") @Valid String masterCode,
                                          @RequestParam("uid") @Valid String uid) {
        return goblinAppZhengzaiService.orderBind(uid, masterCode);
    }
}
